/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.config;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptDocumentationHandler;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.LockHandler;
import com.bloodnbonesgaming.topography.world.WorldProviderConfigurable;
import com.bloodnbonesgaming.topography.world.WorldProviderConfigurableSurface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/Topography", classExplaination="This file is for options in the Topography.txt file. If Topography.txt does not exist, default configs and documentation will be printed.")
public class ConfigurationManager {
    private final List<WorldType> worldTypes = new ArrayList<WorldType>();
    final Map<String, ConfigPreset> presets = new LinkedHashMap<String, ConfigPreset>();
    private final Map<Integer, DimensionType> dimensionMapCopy = new HashMap<Integer, DimensionType>();
    private static final Map<Integer, DimensionType> dimensionTypes = new HashMap<Integer, DimensionType>();
    private static final Map<Integer, DimensionType> dimensionTypesSurface = new HashMap<Integer, DimensionType>();
    private final List<Integer> registeredDimensions = new ArrayList<Integer>();
    private final LockHandler locks = new LockHandler();
    private String generatorSettings = null;
    private boolean defaultWorldType = false;
    private boolean printDocumentation = true;
    private int spawnStructureSpacing = 64;
    private boolean disableWorldTypeButton = false;
    private ExecutorService executor;
    private static ConfigurationManager instance;

    public static ConfigurationManager getInstance() {
        return instance;
    }

    public static void setGeneratorSettings(String settings) {
        ConfigurationManager.setup();
        ConfigurationManager.getInstance().generatorSettings = settings;
        Topography.instance.getLog().info((Object)("Settings: " + settings));
    }

    public String getGeneratorSettings() {
        return this.generatorSettings;
    }

    public static void setup() {
        ConfigurationManager.cleanUp();
        instance = new ConfigurationManager();
        instance.readWorldTypes();
        ConfigurationManager.printDocumentation();
        instance.loadLockHandler();
    }

    public static void printDocumentation() {
        if (ConfigurationManager.instance.printDocumentation) {
            Topography.instance.getLog().info((Object)"Printing documentation to ./config/topography/documentation/");
            ScriptDocumentationHandler.printAnnotatedDocumentation((String)"com.bloodnbonesgaming.topography");
            ScriptDocumentationHandler.copyDocumentationFolder(ConfigurationManager.class, (String)"./config/topography/documentation/");
        }
    }

    public static void cleanUp() {
        Topography.instance.getLog().info((Object)"Cleaning up");
        if (instance != null) {
            for (WorldType type : ConfigurationManager.instance.worldTypes) {
                WorldType.field_77139_a[type.func_82747_f()] = null;
            }
            for (Integer id : ConfigurationManager.instance.registeredDimensions) {
                if (!DimensionManager.isDimensionRegistered((int)id)) continue;
                if (!ConfigurationManager.instance.dimensionMapCopy.containsKey(id)) {
                    Topography.instance.getLog().info((Object)("Unregistering Dimension " + id));
                    DimensionManager.unregisterDimension((int)id);
                    continue;
                }
                if (DimensionManager.getProviderType((int)id) == ConfigurationManager.instance.dimensionMapCopy.get(id)) continue;
                Topography.instance.getLog().info((Object)("Unregistering Dimension " + id));
                DimensionManager.unregisterDimension((int)id);
                Topography.instance.getLog().info((Object)("Registering Dimension " + id));
                DimensionManager.registerDimension((int)id, (DimensionType)ConfigurationManager.instance.dimensionMapCopy.get(id));
            }
            if (ConfigurationManager.instance.executor != null) {
                ConfigurationManager.instance.executor.shutdown();
                try {
                    ConfigurationManager.instance.executor.awaitTermination(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            instance = null;
        }
        Topography.instance.getLog().info((Object)"Done clean-up");
    }

    public void registerDimensions() {
        Topography.instance.getLog().info((Object)"Re-Registering dimensions");
        this.loadDimensionMap();
        ConfigPreset preset = this.getPreset();
        if (preset != null) {
            Topography.instance.getLog().info((Object)("Preset " + preset.getName()));
            Topography.instance.getLog().info((Object)"Loading all dimension definitions");
            if (preset != null) {
                preset.loadAllDefinitions();
            }
            Topography.instance.getLog().info((Object)"All dimension definitions loaded");
            for (int dimension : preset.getDimensions()) {
                DimensionType type;
                if (preset.getDefinition(dimension).isCompatSurface()) {
                    if (!dimensionTypesSurface.containsKey(dimension)) {
                        type = DimensionType.register((String)("DIM_" + dimension), (String)("_DIM_" + dimension), (int)dimension, WorldProviderConfigurableSurface.class, (dimension == 0 ? 1 : 0) != 0);
                        dimensionTypesSurface.put(dimension, type);
                    } else {
                        type = dimensionTypesSurface.get(dimension);
                    }
                } else if (!dimensionTypes.containsKey(dimension)) {
                    type = DimensionType.register((String)("DIM_" + dimension), (String)("_DIM_" + dimension), (int)dimension, WorldProviderConfigurable.class, (dimension == 0 ? 1 : 0) != 0);
                    dimensionTypes.put(dimension, type);
                } else {
                    type = dimensionTypes.get(dimension);
                }
                if (DimensionManager.isDimensionRegistered((int)dimension)) {
                    Topography.instance.getLog().info((Object)("Unregistering Dimension " + dimension));
                    DimensionManager.unregisterDimension((int)dimension);
                }
                Topography.instance.getLog().info((Object)("Registering Dimension " + dimension));
                DimensionManager.registerDimension((int)dimension, (DimensionType)type);
                this.registeredDimensions.add(dimension);
            }
        }
        Topography.instance.getLog().info((Object)"Done Re-Registering dimensions");
    }

    private void loadDimensionMap() {
        Topography.instance.getLog().info((Object)"Caching dimensions");
        for (DimensionType type : DimensionType.values()) {
            int[] dimensions = DimensionManager.getDimensions((DimensionType)type);
            for (int i = 0; i < dimensions.length; ++i) {
                Topography.instance.getLog().info((Object)("Caching Dimension " + dimensions[i]));
                this.dimensionMapCopy.put(dimensions[i], type);
            }
        }
        Topography.instance.getLog().info((Object)"Done caching dimensions");
    }

    private void readWorldTypes() {
        IOHelper.readMainFile(this, null);
    }

    public Map<String, ConfigPreset> getPresets() {
        return this.presets;
    }

    @ScriptMethodDocumentation(args="String", usage="preset name", notes="Creates a preset object and returns it.")
    public ConfigPreset registerPreset(String name) {
        ConfigPreset preset = new ConfigPreset(name, "");
        this.presets.put(name, preset);
        return preset;
    }

    @ScriptMethodDocumentation(args="String, String", usage="preset name, image location", notes="Creates a preset object and returns it. Image references a file in the topography folder. Image may be null.")
    public ConfigPreset registerPreset(String name, String image) {
        ConfigPreset preset = new ConfigPreset(name, image);
        this.presets.put(name, preset);
        return preset;
    }

    @ScriptMethodDocumentation(args="String, String, String", usage="preset name, image location, description", notes="Creates a preset object and returns it. Image references a file in the topography folder. Image/description may be null.")
    public ConfigPreset registerPreset(String name, String image, String description) {
        ConfigPreset preset = new ConfigPreset(name, image, description);
        this.presets.put(name, preset);
        return preset;
    }

    @ScriptMethodDocumentation(args="String, String, String, String", usage="preset name, image location, description, WorldType", notes="Creates a preset object and returns it. Image references a file in the topography folder. Setting a WorldType uses that WorldType as the base for the preset, allowing for things like using BoP for the overworld while having a custom nether dimension. Image/description/worldtype may be null.")
    public ConfigPreset registerPreset(String name, String image, String description, String worldType) {
        ConfigPreset preset = new ConfigPreset(name, image, description, worldType);
        this.presets.put(name, preset);
        return preset;
    }

    @ScriptMethodDocumentation(args="String, String, String, String, String", usage="preset name, image location, description, WorldType, generator options", notes="Creates a preset object and returns it. Image references a file in the topography folder. Setting a WorldType uses that WorldType as the base for the preset, allowing for things like using BoP for the overworld while having a custom nether dimension. Generator options sets the generator options for the chosen WorldType. Image/description/worldtype/generator options may be null.")
    public ConfigPreset registerPreset(String name, String image, String description, String worldType, String generatorOptions) {
        ConfigPreset preset = new ConfigPreset(name, image, description, worldType, generatorOptions);
        this.presets.put(name, preset);
        return preset;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the Topography WorldType as default.")
    public void setAsDefaultWorldType() {
        this.defaultWorldType = true;
    }

    public boolean defaultWorldType() {
        return this.defaultWorldType;
    }

    @ScriptMethodDocumentation(args="int", usage="spacing", notes="Sets the spacing between spawn structures.")
    public void setSpawnStructureSpacing(int spacing) {
        this.spawnStructureSpacing = spacing;
    }

    public int getSpawnStructureSpacing() {
        return this.spawnStructureSpacing;
    }

    public ConfigPreset getPreset() {
        return this.presets.get(this.generatorSettings);
    }

    public LockHandler getLockHandler() {
        return this.locks;
    }

    private void loadLockHandler() {
        IOHelper.loadUnlockFile(this.locks);
    }

    public boolean unlockPreset(String preset) {
        if (this.locks.unlock(preset)) {
            IOHelper.saveUnlockFile(this.locks);
            return true;
        }
        return false;
    }

    public boolean lockPreset(String preset) {
        if (this.locks.lock(preset)) {
            IOHelper.saveUnlockFile(this.locks);
            return true;
        }
        return false;
    }

    public ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
        return this.executor;
    }

    public void printDocumentation(boolean bool) {
        this.printDocumentation = bool;
    }
}

