/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.proxy;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.event.ClientEventSubscriber;
import com.bloodnbonesgaming.topography.event.WorldBookEventHandler;
import com.bloodnbonesgaming.topography.proxy.CommonProxy;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventSubscriber());
        if (Topography.worldbook) {
            MinecraftForge.EVENT_BUS.register((Object)new WorldBookEventHandler());
        }
    }

    @Override
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        super.onServerAboutToStart(event);
        if (event.getServer() instanceof IntegratedServer) {
            WorldInfo worldinfo;
            IntegratedServer server = (IntegratedServer)event.getServer();
            if (ConfigurationManager.getInstance() != null && (worldinfo = IOHelper.readWorldInfo(server.func_71270_I())) != null) {
                JsonObject obj;
                JsonElement member;
                String settings = worldinfo.func_82571_y();
                JsonParser parser = new JsonParser();
                Topography.instance.getLog().info((Object)("reading json " + settings));
                JsonElement element = parser.parse(settings);
                if (element.isJsonObject() && (member = (obj = (JsonObject)element).get("Topography-Preset")) != null) {
                    settings = member.getAsString();
                    ConfigurationManager.setup();
                    ConfigurationManager.setGeneratorSettings(settings);
                    ConfigurationManager.getInstance().registerDimensions();
                }
            }
        }
    }
}

