/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation//biome_providers//genlayers/GenLayerRiverMixDC", classExplaination="A configurable version of the vanilla GenLayerRiverMix. Uses a biome map and a river map layer to set configurable river biomes for biomes.")
public class GenLayerRiverMixDC
extends GenLayer {
    private final GenLayer biomePatternGeneratorChain;
    private final GenLayer riverPatternGeneratorChain;
    private Map<Integer, Integer> riverBiomes = new HashMap<Integer, Integer>();

    @ScriptMethodDocumentation(args="long, GenLayer, GenLayer", usage="base layer seed, biome map parent layer, river map layer", notes="Constructs the layer, setting the base layer seed and parent layers.")
    public GenLayerRiverMixDC(long seed, GenLayer biomePatternGeneratorChain, GenLayer riverPatternGeneratorChain) {
        super(seed);
        this.biomePatternGeneratorChain = biomePatternGeneratorChain;
        this.riverPatternGeneratorChain = riverPatternGeneratorChain;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome ID, river biome ID", notes="Sets the river biome for the provided biomeID.")
    public void setRiverBiome(int biome, int river) {
        this.riverBiomes.put(biome, river);
    }

    public void func_75905_a(long seed) {
        this.biomePatternGeneratorChain.func_75905_a(seed);
        this.riverPatternGeneratorChain.func_75905_a(seed);
        super.func_75905_a(seed);
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] biomeInts = this.biomePatternGeneratorChain.func_75904_a(chunkX, chunkZ, width, depth);
        int[] riverInts = this.riverPatternGeneratorChain.func_75904_a(chunkX, chunkZ, width, depth);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int i = 0; i < width * depth; ++i) {
            if (riverInts[i] == Biome.func_185362_a((Biome)Biomes.field_76781_i)) {
                if (!this.riverBiomes.isEmpty()) {
                    Integer river = this.riverBiomes.get(biomeInts[i]);
                    if (river != null) {
                        if (river > -1) {
                            returnInts[i] = river;
                            continue;
                        }
                        returnInts[i] = biomeInts[i];
                        continue;
                    }
                    returnInts[i] = Biome.func_185362_a((Biome)Biomes.field_76781_i);
                    continue;
                }
                if (biomeInts[i] != Biome.func_185362_a((Biome)Biomes.field_76771_b) && biomeInts[i] != Biome.func_185362_a((Biome)Biomes.field_150575_M)) {
                    if (biomeInts[i] == Biome.func_185362_a((Biome)Biomes.field_76774_n)) {
                        returnInts[i] = Biome.func_185362_a((Biome)Biomes.field_76777_m);
                        continue;
                    }
                    if (biomeInts[i] != Biome.func_185362_a((Biome)Biomes.field_76789_p) && biomeInts[i] != Biome.func_185362_a((Biome)Biomes.field_76788_q)) {
                        returnInts[i] = riverInts[i] & 0xFF;
                        continue;
                    }
                    returnInts[i] = Biome.func_185362_a((Biome)Biomes.field_76788_q);
                    continue;
                }
                returnInts[i] = biomeInts[i];
                continue;
            }
            returnInts[i] = biomeInts[i];
        }
        return returnInts;
    }
}

