/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

public class GenLayerTouchingData {
    private final int[] biomes;
    private final int[] whitelist;
    private final int[] blacklist;
    private final int requiredCount;
    private final int replacement;
    private final int chance;

    public GenLayerTouchingData(int[] biomes, int[] whitelist, int[] blacklist, int requiredCount, int replacement, int chance) {
        this.biomes = biomes;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.requiredCount = requiredCount;
        this.chance = chance;
        this.replacement = replacement;
    }

    public boolean replace(int biome) {
        if (this.whitelist == null && this.blacklist == null) {
            return true;
        }
        return this.whitelist == null ? !this.inBlacklist(biome) : this.blacklist == null && this.inWhitelist(biome);
    }

    private boolean inWhitelist(int biome) {
        if (this.whitelist != null) {
            for (int biomeID : this.whitelist) {
                if (biomeID != biome) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inBlacklist(int biome) {
        if (this.blacklist != null) {
            for (int biomeID : this.blacklist) {
                if (biomeID != biome) continue;
                return true;
            }
        }
        return false;
    }

    public boolean usedForBiome(int biome) {
        if (this.biomes != null) {
            for (int biomeID : this.biomes) {
                if (biomeID != biome) continue;
                return true;
            }
        }
        return false;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public int getReplacement() {
        return this.replacement;
    }

    public int getChance() {
        return this.chance;
    }
}

