/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/HangingCrystalGenerator", classExplaination="This file is for the HangingCrystalGenerator. This generator generates hanging clusters of blocks, similar to glowstone.")
public class HangingCrystalGenerator
implements IGenerator {
    private final int count;
    private final int expansionAttempts;
    private int minHeight = 4;
    private int maxHeight = 250;
    private final IBlockState block;
    private final List<BlockPredicate> requiredBlocks = new ArrayList<BlockPredicate>();

    @ScriptMethodDocumentation(args="ItemBlockData, int, int", usage="block to generate, clusters per chunk, cluster expansion attempts", notes="This constructs a HangingCrystalGenerator.")
    public HangingCrystalGenerator(ItemBlockData data, int count, int expansionAttempts) throws Exception {
        this.block = data.buildBlockState();
        this.count = count;
        this.expansionAttempts = expansionAttempts;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="required block", notes="Adds a block the generator is allowed to start generating a cluster under. By default can generate under any block.")
    public void addRequiredBlock(ItemBlockData data) throws Exception {
        this.requiredBlocks.add(data.buildBlockPredicate());
    }

    @ScriptMethodDocumentation(args="int, int", usage="min height, max height", notes="Sets the min and max heights this generator can generate at. Default is 4 and 250.")
    public void setHeight(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.count; ++i) {
            int x = chunkX * 16 + rand.nextInt(16) + 8;
            int y = rand.nextInt(this.maxHeight - this.minHeight + 1) + this.minHeight;
            int z = chunkZ * 16 + rand.nextInt(16) + 8;
            mutable.func_181079_c(x, y, z);
            if (!world.func_175623_d((BlockPos)mutable) || !this.isBlockAcceptable(world, mutable.func_177984_a())) continue;
            world.func_180501_a((BlockPos)mutable, this.block, 2);
            for (int index = 0; index < this.expansionAttempts; ++index) {
                int x2 = x + rand.nextInt(8) - rand.nextInt(8);
                int y2 = y - rand.nextInt(12);
                int z2 = z + rand.nextInt(8) - rand.nextInt(8);
                mutable.func_181079_c(x2, y2, z2);
                if (!world.func_175623_d((BlockPos)mutable)) continue;
                int crystal = 0;
                if (world.func_180495_p((BlockPos)mutable2.func_181079_c(x2, y2, z2 - 1)) == this.block) {
                    ++crystal;
                }
                if (world.func_180495_p((BlockPos)mutable2.func_181079_c(x2, y2, z2 + 1)) == this.block && ++crystal > 1 || world.func_180495_p((BlockPos)mutable2.func_181079_c(x2 + 1, y2, z2)) == this.block && ++crystal > 1 || world.func_180495_p((BlockPos)mutable2.func_181079_c(x2 - 1, y2, z2)) == this.block && ++crystal > 1 || world.func_180495_p((BlockPos)mutable2.func_181079_c(x2, y2 + 1, z2)) == this.block && ++crystal > 1 || world.func_180495_p((BlockPos)mutable2.func_181079_c(x2, y2 - 1, z2)) == this.block && ++crystal > 1 || crystal != 1) continue;
                world.func_180501_a((BlockPos)mutable, this.block, 2);
            }
        }
    }

    private boolean isBlockAcceptable(World world, BlockPos pos) {
        if (this.requiredBlocks.isEmpty() && !world.func_175623_d(pos)) {
            return true;
        }
        for (BlockPredicate predicate : this.requiredBlocks) {
            if (!predicate.test(world.func_180495_p(pos))) continue;
            return true;
        }
        return false;
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }
}

