/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator.vanilla.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.structure.MapGenEndCity;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureEndCityPieces;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class EndCityGenerator
extends MapGenEndCity {
    public final int frequency;
    public final int totalArea;
    public final int randomArea;
    public final boolean requiresIsland = false;
    public final MinMaxBounds height;

    public EndCityGenerator(int frequency, int totalArea, int randomArea, MinMaxBounds height) {
        super(null);
        this.frequency = frequency;
        this.totalArea = totalArea;
        this.randomArea = randomArea;
        this.height = height;
    }

    public String func_143025_a() {
        return "EndCity";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX / this.totalArea;
        int j = chunkZ / this.totalArea;
        this.field_75038_b.setSeed((long)(i ^ j * this.totalArea) ^ this.field_75039_c.func_72905_C());
        if (Math.abs(chunkX % this.totalArea) == this.totalArea / 2 + (this.randomArea > 0 ? this.field_75038_b.nextInt(this.randomArea) : 0) - this.randomArea / 2 && Math.abs(chunkZ % this.totalArea) == this.totalArea / 2 + (this.randomArea > 0 ? this.field_75038_b.nextInt(this.randomArea) : 0) - this.randomArea / 2) {
            this.field_75038_b.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            boolean value = this.frequency > 1 ? this.field_75038_b.nextInt(this.frequency) == 0 : true;
            return value;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return EndCityGenerator.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)20, (int)11, (int)10387313, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    public static class Start
    extends MapGenEndCity.Start {
        private boolean isSizeable;

        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(worldIn, null, random, chunkX, chunkZ);
        }

        public void func_186162_a(World worldIn, ChunkGeneratorEnd chunkProvider, Random rnd, int chunkX, int chunkZ) {
            Random random = new Random(chunkX + chunkZ * 10387313);
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            int i = 60;
            if (i < 60) {
                this.isSizeable = false;
            } else {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i, chunkZ * 16 + 8);
                StructureEndCityPieces.func_191087_a((TemplateManager)worldIn.func_72860_G().func_186340_h(), (BlockPos)blockpos, (Rotation)rotation, (List)this.field_75075_a, (Random)rnd);
                this.func_75072_c();
                this.isSizeable = true;
            }
        }

        public boolean func_75069_d() {
            return this.isSizeable;
        }

        static {
            MapGenStructureIO.func_143034_b(Start.class, (String)"EndCity");
        }
    }
}

