/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.asm;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMUtil
implements Opcodes {
    public static boolean hasAccess(int input, int access) {
        return (input & access) != 0;
    }

    public static boolean isAbstract(int input) {
        return ASMUtil.hasAccess(input, 1024);
    }

    public static boolean isStatic(int input) {
        return ASMUtil.hasAccess(input, 8);
    }

    public static boolean isFinal(int input) {
        return ASMUtil.hasAccess(input, 16);
    }

    public static boolean isTransient(int input) {
        return ASMUtil.hasAccess(input, 128);
    }

    public static boolean isPrimitive(String desc) {
        if (desc.length() != 1) {
            return false;
        }
        int type = Type.getType((String)desc).getSort();
        return type >= 1 && type <= 8;
    }

    public static MethodNode findMethod(ClassNode classNode, String desc, String ... names) {
        for (MethodNode m : classNode.methods) {
            if (desc != null && !m.desc.equalsIgnoreCase(desc)) continue;
            for (String name : names) {
                if (!m.name.equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    public static boolean hasMethod(ClassNode classNode, String desc, String ... names) {
        return ASMUtil.findMethod(classNode, desc, names) != null;
    }

    public static void createEmptyDefaultConstructor(ClassNode classNode) {
        MethodVisitor m = classNode.visitMethod(1, "<init>", "()V", null, null);
        m.visitCode();
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, classNode.superName, "<init>", "()V", false);
        m.visitInsn(177);
        m.visitEnd();
    }
}

