/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtension;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import java.util.List;
import net.minecraft.init.SoundEvents;

public class GuiComboBox
extends GuiLabel {
    public GuiComboBoxExtension extension;
    public List<String> lines;
    public int index;

    public GuiComboBox(String name, int x, int y, int width, List<String> lines) {
        super(name, x, y, width, 14, -1);
        if (lines.size() > 0) {
            this.caption = lines.get(0);
            this.index = 0;
        } else {
            this.caption = "";
            this.index = -1;
        }
        this.lines = lines;
    }

    public boolean select(int index) {
        if (index >= 0 && index < this.lines.size()) {
            this.caption = this.lines.get(index);
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    public boolean select(String line) {
        this.index = this.lines.indexOf(line);
        if (this.index != -1) {
            this.caption = this.lines.get(this.index);
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    @Override
    public boolean hasBackground() {
        return true;
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        if (this.extension == null) {
            this.openBox();
        } else {
            this.closeBox();
        }
        GuiComboBox.playSound(SoundEvents.field_187909_gi);
        return true;
    }

    public void openBox() {
        this.extension = this.createBox();
        this.getGui().controls.add(this.extension);
        this.extension.parent = this.getGui();
        this.extension.moveControlToTop();
        this.extension.onOpened();
        this.getGui().refreshControls();
        this.extension.rotation = this.rotation;
        this.extension.posX = this.getPixelOffsetX() - this.getGui().getPixelOffsetX() - this.getContentOffset();
        this.extension.posY = this.getPixelOffsetY() - this.getGui().getPixelOffsetY() - this.getContentOffset() + this.height;
        if (this.extension.posY + this.extension.height > this.getParent().height && this.posY >= this.extension.height) {
            this.extension.posY -= this.height + this.extension.height;
        }
    }

    protected GuiComboBoxExtension createBox() {
        return new GuiComboBoxExtension(this.name + "extension", this, this.posX, this.posY + this.height, this.width - this.getContentOffset() * 2, 100, this.lines);
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getGui().controls.remove(this.extension);
            this.extension = null;
        }
    }
}

