/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.container.ContainerEmpty;
import thelm.packagedauto.util.PatternHelper;
import thelm.packagedexcrafting.recipe.IRecipeInfoTiered;
import thelm.packagedexcrafting.recipe.RecipeTypeBasic;

public class RecipeInfoBasic
implements IRecipeInfoTiered {
    IRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    InventoryCrafting matrix = new InventoryCrafting((Container)new ContainerEmpty(), 3, 3);
    ItemStack output;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void readFromNBT(NBTTagCompound nbt) {
        this.input.clear();
        this.output = ItemStack.field_190927_a;
        this.patterns.clear();
        ArrayList matrixList = new ArrayList();
        MiscUtil.loadAllItems((NBTTagList)nbt.func_150295_c("Matrix", 10), matrixList);
        for (int i = 0; i < 9 && i < matrixList.size(); ++i) {
            this.matrix.func_70299_a(i, (ItemStack)matrixList.get(i));
        }
        for (Object obj : TableRecipeManager.getInstance().getRecipes(3)) {
            IRecipe recipe;
            if (!(obj instanceof IRecipe) || !(recipe = (IRecipe)obj).func_77569_a(this.matrix, null)) continue;
            this.recipe = recipe;
            break;
        }
        if (this.recipe != null) {
            this.input.addAll(MiscUtil.condenseStacks((IInventory)this.matrix));
            this.output = this.recipe.func_77572_b(this.matrix).func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
                ++i;
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            matrixList.add(this.matrix.func_70301_a(i));
        }
        NBTTagList matrixTag = MiscUtil.saveAllItems((NBTTagList)new NBTTagList(), matrixList);
        nbt.func_74782_a("Matrix", (NBTBase)matrixTag);
        return nbt;
    }

    public IRecipeType getRecipeType() {
        return RecipeTypeBasic.INSTANCE;
    }

    @Override
    public int getTier() {
        return 1;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public IRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public InventoryCrafting getMatrix() {
        return this.matrix;
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = RecipeTypeBasic.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.func_190920_e(1);
            this.matrix.func_70299_a(i, toSet.func_77946_l());
        }
        for (Object obj : TableRecipeManager.getInstance().getRecipes(3)) {
            IRecipe recipe;
            if (!(obj instanceof IRecipe) || !(recipe = (IRecipe)obj).func_77569_a(this.matrix, world)) continue;
            this.recipe = recipe;
            this.input.addAll(MiscUtil.condenseStacks((IInventory)this.matrix));
            this.output = recipe.func_77572_b(this.matrix).func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
                ++i;
            }
            return;
        }
        this.matrix.func_174888_l();
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = RecipeTypeBasic.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            map.put(slotArray[i], (Object)this.matrix.func_70301_a(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoBasic) {
            RecipeInfoBasic other = (RecipeInfoBasic)obj;
            for (int i = 0; i < this.input.size(); ++i) {
                if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.input.get(i), (ItemStack)other.input.get(i))) continue;
                return false;
            }
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        Object[] toHash = new Object[2];
        Object[] inputArray = new Object[this.input.size()];
        for (int i = 0; i < this.input.size(); ++i) {
            ItemStack stack = this.input.get(i);
            inputArray[i] = new Object[]{stack.func_77973_b(), stack.func_77952_i(), stack.func_190916_E(), stack.func_77978_p()};
        }
        toHash[0] = this.recipe;
        toHash[1] = inputArray;
        return Arrays.deepHashCode(toHash);
    }
}

