/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import com.google.common.collect.ImmutableSortedMap;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.api.IRecipeType;

public class RecipeTypeRegistry {
    private static final SortedMap<ResourceLocation, IRecipeType> REGISTRY = new TreeMap<ResourceLocation, IRecipeType>();
    private static final IntIdentityHashBiMap<IRecipeType> ID_MAP = new IntIdentityHashBiMap(4);
    private static int id = 0;

    private RecipeTypeRegistry() {
    }

    public static boolean registerRecipeType(IRecipeType type) {
        if (REGISTRY.containsKey(type.getName())) {
            return false;
        }
        REGISTRY.put(type.getName(), type);
        ID_MAP.func_186814_a((Object)type, id++);
        return true;
    }

    public static IRecipeType getRecipeType(ResourceLocation name) {
        return (IRecipeType)REGISTRY.get(name);
    }

    public static IRecipeType getRecipeType(int id) {
        return (IRecipeType)ID_MAP.func_186813_a(id);
    }

    public static int getId(IRecipeType type) {
        return ID_MAP.func_186815_a((Object)type);
    }

    public static NavigableMap<ResourceLocation, IRecipeType> getRegistry() {
        return ImmutableSortedMap.copyOf(REGISTRY);
    }

    public static IRecipeType getNextRecipeType(IRecipeType type) {
        int toGet = ID_MAP.func_186815_a((Object)type) + 1;
        IRecipeType ret = (IRecipeType)ID_MAP.func_186813_a(toGet);
        if (ret == null) {
            ret = (IRecipeType)ID_MAP.func_186813_a(0);
        }
        return ret;
    }
}

