/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logisticspipes.gui.hud.modules.HUDCCBasedQuickSort;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.ModuleQuickSort;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.CCBasedQuickSortInHand;
import logisticspipes.network.guis.module.inpipe.CCBasedQuickSortSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.modules.CCBasedQuickSortMode;
import logisticspipes.network.packets.modules.CCBasedQuickSortSinkSize;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class ModuleCCBasedQuickSort
extends ModuleQuickSort
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    private Map<Integer, Pair<Integer, List<CCSinkResponder>>> sinkResponses = new HashMap<Integer, Pair<Integer, List<CCSinkResponder>>>();
    private int timeout = 100;
    private int sinkSize = 0;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private IHUDModuleRenderer HUD = new HUDCCBasedQuickSort(this);

    private void createSinkMessage(int slot, ItemIdentifierStack stack) {
        ArrayList<CCSinkResponder> respones = new ArrayList<CCSinkResponder>();
        IRouter sourceRouter = this._service.getRouter();
        if (sourceRouter == null) {
            return;
        }
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn((ItemIdentifier)null);
        ArrayList validDestinations = new ArrayList();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            List<ExitRoute> exits = sourceRouter.getDistanceTo(r);
            if (exits != null) {
                validDestinations.addAll(exits.stream().filter(e -> e.containsFlag(PipeRoutingConnectionType.canRouteTo)).collect(Collectors.toList()));
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validDestinations);
        block1: for (ExitRoute candidateRouter : validDestinations) {
            if (candidateRouter.destination.getId().equals(sourceRouter.getId())) continue;
            for (IFilter filter : candidateRouter.filters) {
                if (!filter.blockRouting() && filter.isBlocked() != filter.isFilteredItem(stack.getItem())) continue;
                continue block1;
            }
            if (candidateRouter.destination == null || candidateRouter.destination.getLogisticsModule() == null) continue;
            respones.addAll(candidateRouter.destination.getLogisticsModule().queueCCSinkEvent(stack));
        }
        this.sinkResponses.put(slot, new Pair(0, respones));
    }

    @Override
    public void tick() {
        IInventoryUtil invUtil = this._service.getPointedInventory();
        if (invUtil == null) {
            return;
        }
        this.handleSinkResponses(invUtil);
        if (--this.currentTick > 0) {
            return;
        }
        this.currentTick = this.stalled ? 24 : 6;
        if (!this._service.canUseEnergy(500)) {
            this.stalled = true;
            return;
        }
        if (!(invUtil instanceof SpecialInventoryHandler) && invUtil.getSizeInventory() == 0 || !this._service.canUseEnergy(500)) {
            this.stalled = true;
            return;
        }
        if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
            this.lastStackLookedAt = 0;
        }
        ItemStack slot = invUtil.getStackInSlot(this.lastStackLookedAt);
        while (slot.func_190926_b()) {
            ++this.lastStackLookedAt;
            if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                this.lastStackLookedAt = 0;
            }
            slot = invUtil.getStackInSlot(this.lastStackLookedAt);
            if (this.lastStackLookedAt != this.lastSuceededStack) continue;
            this.stalled = true;
            this.send();
            return;
        }
        this.send();
        if (!this.sinkResponses.containsKey(this.lastStackLookedAt)) {
            this.createSinkMessage(this.lastStackLookedAt, ItemIdentifierStack.getFromStack(slot));
        }
        ++this.lastStackLookedAt;
        this.checkSize();
    }

    private void handleSinkResponses(IInventoryUtil invUtil) {
        boolean changed = false;
        Iterator<Map.Entry<Integer, Pair<Integer, List<CCSinkResponder>>>> iter = this.sinkResponses.entrySet().iterator();
        while (iter.hasNext()) {
            boolean slotInInventory;
            Map.Entry<Integer, Pair<Integer, List<CCSinkResponder>>> pair = iter.next();
            pair.getValue().setValue1(pair.getValue().getValue1() + 1);
            boolean canBeHandled = true;
            for (CCSinkResponder response : pair.getValue().getValue2()) {
                if (response.isDone()) continue;
                canBeHandled = false;
                break;
            }
            if (!canBeHandled && pair.getValue().getValue1() <= this.timeout) continue;
            boolean bl = slotInInventory = pair.getKey() < invUtil.getSizeInventory();
            if (slotInInventory && this.handle(invUtil, pair.getKey(), pair.getValue().getValue2())) {
                this.stalled = false;
                this.lastSuceededStack = pair.getKey();
            }
            iter.remove();
            changed = true;
        }
        if (changed) {
            this.checkSize();
        }
    }

    private boolean handle(IInventoryUtil invUtil, int slot, List<CCSinkResponder> list) {
        if (list.isEmpty()) {
            return false;
        }
        ItemIdentifier ident = list.get(0).getStack().getItem();
        ItemStack stack = invUtil.getStackInSlot(slot);
        if (stack.func_190926_b() || !ItemIdentifier.get(stack).equals(ident)) {
            return false;
        }
        IRouter source = this._service.getRouter();
        ArrayList<Triplet<Integer, Double, CCSinkResponder>> possibilities = new ArrayList<Triplet<Integer, Double, CCSinkResponder>>();
        for (CCSinkResponder sink : list) {
            IRouter iRouter;
            if (!sink.isDone() || sink.getCanSink() < 1 || (iRouter = SimpleServiceLocator.routerManager.getRouter(sink.getRouterId())) == null) continue;
            List<ExitRoute> ways = source.getDistanceTo(iRouter);
            double minDistance = Double.MAX_VALUE;
            block1: for (ExitRoute route : ways) {
                for (IFilter filter : route.filters) {
                    if (!filter.blockRouting() && filter.isFilteredItem(ident) != filter.isBlocked()) continue;
                    continue block1;
                }
                minDistance = Math.min(route.distanceToDestination, minDistance);
            }
            if (minDistance == 2.147483647E9) continue;
            possibilities.add(new Triplet<Integer, Double, CCSinkResponder>(sink.getPriority(), minDistance, sink));
        }
        if (possibilities.isEmpty()) {
            return false;
        }
        possibilities.sort((left, right) -> {
            int prioritySign = Integer.compare((Integer)right.getValue1(), (Integer)left.getValue1());
            if (prioritySign == 0) {
                return Double.compare((Double)left.getValue2(), (Double)right.getValue2());
            }
            return prioritySign;
        });
        boolean isSent = false;
        for (Triplet triplet : possibilities) {
            CCSinkResponder sink = (CCSinkResponder)triplet.getValue3();
            if (sink.getCanSink() < 0 || (stack = invUtil.getStackInSlot(slot)).func_190926_b()) continue;
            int amount = Math.min(stack.func_190916_E(), sink.getCanSink());
            ItemStack extracted = invUtil.decrStackSize(slot, amount);
            this._service.sendStack(extracted, sink.getRouterId(), CoreRoutedPipe.ItemSendMode.Fast, null);
            isSent = true;
        }
        return isSent;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.timeout = nbttagcompound.func_74762_e("Timeout");
        if (this.timeout == 0) {
            this.timeout = 100;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Timeout", this.timeout);
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("Timeout: " + this.timeout);
        return list;
    }

    private void checkSize() {
        if (this.sinkSize != this.sinkResponses.size()) {
            this.sinkSize = this.sinkResponses.size();
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CCBasedQuickSortSinkSize.class).setSinkSize(this.sinkSize).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CCBasedQuickSortMode.class).setTimeOut(this.timeout).setModulePos(this), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CCBasedQuickSortSinkSize.class).setSinkSize(this.sinkSize).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    public void setTimeout(int time) {
        this.timeout = time;
        if (MainProxy.isServer((IBlockAccess)this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CCBasedQuickSortMode.class).setTimeOut(this.timeout).setModulePos(this), this.localModeWatchers);
        }
    }

    public void setSinkSize(int integer) {
        if (MainProxy.isClient((IBlockAccess)this._world.getWorld())) {
            this.sinkSize = integer;
        }
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(CCBasedQuickSortSlot.class).setTimeOut(this.timeout);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(CCBasedQuickSortInHand.class);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getSinkSize() {
        return this.sinkSize;
    }
}

