/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.util.UUID;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class DeleteChannelPacket
extends ModernPacket {
    private UUID channelIdentifier;

    public DeleteChannelPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.channelIdentifier = input.readUUID();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeUUID(this.channelIdentifier);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        IChannelManager manager = SimpleServiceLocator.channelManagerProvider.getChannelManager(player.func_130014_f_());
        manager.removeChannel(this.channelIdentifier);
    }

    @Override
    public ModernPacket template() {
        return new DeleteChannelPacket(this.getId());
    }

    public UUID getChannelIdentifier() {
        return this.channelIdentifier;
    }

    public DeleteChannelPacket setChannelIdentifier(UUID channelIdentifier) {
        this.channelIdentifier = channelIdentifier;
        return this;
    }
}

