/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.BitSet;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PipeFluidUpdate
extends CoordinatesPacket {
    private FluidStack[] renderCache = new FluidStack[EnumFacing.field_82609_l.length];
    private BitSet bits = new BitSet();

    public PipeFluidUpdate(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.bits = input.readBitSet();
        for (int i = 0; i < this.renderCache.length; ++i) {
            if (!this.bits.get(i)) continue;
            this.renderCache[i] = new FluidStack(FluidRegistry.getFluid((String)input.readUTF()), input.readInt(), input.readNBTTagCompound());
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        for (int i = 0; i < this.renderCache.length; ++i) {
            this.bits.set(i, this.renderCache[i] != null);
        }
        output.writeBitSet(this.bits);
        for (FluidStack aRenderCache : this.renderCache) {
            if (aRenderCache == null) continue;
            output.writeUTF(aRenderCache.getFluid().getName());
            output.writeInt(aRenderCache.amount);
            output.writeNBTTagCompound(aRenderCache.tag);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.field_70170_p);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeFluidTransportLogistics)) {
            return;
        }
        ((PipeFluidTransportLogistics)pipe.pipe.transport).renderCache = this.renderCache;
    }

    @Override
    public ModernPacket template() {
        return new PipeFluidUpdate(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    private FluidStack[] getRenderCache() {
        return this.renderCache;
    }

    public PipeFluidUpdate setRenderCache(FluidStack[] renderCache) {
        this.renderCache = renderCache;
        return this;
    }
}

