/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialconnection;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import logisticspipes.interfaces.routing.ISpecialPipedConnection;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import net.minecraft.util.EnumFacing;

public class SpecialPipeConnection {
    private List<ISpecialPipedConnection> handler = new ArrayList<ISpecialPipedConnection>();

    public void registerHandler(ISpecialPipedConnection connectionHandler) {
        if (connectionHandler.init()) {
            this.handler.add(connectionHandler);
        }
    }

    public List<ConnectionInformation> getConnectedPipes(IPipeInformationProvider startPipe, EnumSet<PipeRoutingConnectionType> connection, EnumFacing side) {
        for (ISpecialPipedConnection connectionHandler : this.handler) {
            if (!connectionHandler.isType(startPipe)) continue;
            return connectionHandler.getConnections(startPipe, connection, side);
        }
        return new ArrayList<ConnectionInformation>();
    }

    public static class ConnectionInformation {
        private IPipeInformationProvider connectedPipe;
        private EnumSet<PipeRoutingConnectionType> connectionFlags;
        private EnumFacing insertOrientation;
        private EnumFacing exitOrientation;
        private double distance;

        public IPipeInformationProvider getConnectedPipe() {
            return this.connectedPipe;
        }

        public EnumSet<PipeRoutingConnectionType> getConnectionFlags() {
            return this.connectionFlags;
        }

        public EnumFacing getInsertOrientation() {
            return this.insertOrientation;
        }

        public EnumFacing getExitOrientation() {
            return this.exitOrientation;
        }

        public double getDistance() {
            return this.distance;
        }

        public ConnectionInformation setConnectedPipe(IPipeInformationProvider connectedPipe) {
            this.connectedPipe = connectedPipe;
            return this;
        }

        public ConnectionInformation setConnectionFlags(EnumSet<PipeRoutingConnectionType> connectionFlags) {
            this.connectionFlags = connectionFlags;
            return this;
        }

        public ConnectionInformation setInsertOrientation(EnumFacing insertOrientation) {
            this.insertOrientation = insertOrientation;
            return this;
        }

        public ConnectionInformation setExitOrientation(EnumFacing exitOrientation) {
            this.exitOrientation = exitOrientation;
            return this;
        }

        public ConnectionInformation setDistance(double distance) {
            this.distance = distance;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectionInformation)) {
                return false;
            }
            ConnectionInformation other = (ConnectionInformation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPipeInformationProvider this$connectedPipe = this.getConnectedPipe();
            IPipeInformationProvider other$connectedPipe = other.getConnectedPipe();
            if (this$connectedPipe == null ? other$connectedPipe != null : !this$connectedPipe.equals(other$connectedPipe)) {
                return false;
            }
            EnumSet<PipeRoutingConnectionType> this$connectionFlags = this.getConnectionFlags();
            EnumSet<PipeRoutingConnectionType> other$connectionFlags = other.getConnectionFlags();
            if (this$connectionFlags == null ? other$connectionFlags != null : !((Object)this$connectionFlags).equals(other$connectionFlags)) {
                return false;
            }
            EnumFacing this$insertOrientation = this.getInsertOrientation();
            EnumFacing other$insertOrientation = other.getInsertOrientation();
            if (this$insertOrientation == null ? other$insertOrientation != null : !this$insertOrientation.equals(other$insertOrientation)) {
                return false;
            }
            EnumFacing this$exitOrientation = this.getExitOrientation();
            EnumFacing other$exitOrientation = other.getExitOrientation();
            if (this$exitOrientation == null ? other$exitOrientation != null : !this$exitOrientation.equals(other$exitOrientation)) {
                return false;
            }
            return Double.compare(this.getDistance(), other.getDistance()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConnectionInformation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPipeInformationProvider $connectedPipe = this.getConnectedPipe();
            result = result * 59 + ($connectedPipe == null ? 43 : $connectedPipe.hashCode());
            EnumSet<PipeRoutingConnectionType> $connectionFlags = this.getConnectionFlags();
            result = result * 59 + ($connectionFlags == null ? 43 : ((Object)$connectionFlags).hashCode());
            EnumFacing $insertOrientation = this.getInsertOrientation();
            result = result * 59 + ($insertOrientation == null ? 43 : $insertOrientation.hashCode());
            EnumFacing $exitOrientation = this.getExitOrientation();
            result = result * 59 + ($exitOrientation == null ? 43 : $exitOrientation.hashCode());
            long $distance = Double.doubleToLongBits(this.getDistance());
            result = result * 59 + (int)($distance >>> 32 ^ $distance);
            return result;
        }

        public String toString() {
            return "SpecialPipeConnection.ConnectionInformation(connectedPipe=" + this.getConnectedPipe() + ", connectionFlags=" + this.getConnectionFlags() + ", insertOrientation=" + this.getInsertOrientation() + ", exitOrientation=" + this.getExitOrientation() + ", distance=" + this.getDistance() + ")";
        }

        @ConstructorProperties(value={"connectedPipe", "connectionFlags", "insertOrientation", "exitOrientation", "distance"})
        public ConnectionInformation(IPipeInformationProvider connectedPipe, EnumSet<PipeRoutingConnectionType> connectionFlags, EnumFacing insertOrientation, EnumFacing exitOrientation, double distance) {
            this.connectedPipe = connectedPipe;
            this.connectionFlags = connectionFlags;
            this.insertOrientation = insertOrientation;
            this.exitOrientation = exitOrientation;
            this.distance = distance;
        }
    }
}

