/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.wrapper;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import leviathan143.loottweaker.common.ErrorHandler;
import leviathan143.loottweaker.common.darkmagic.LootPoolAccessors;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.DataParser;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootFunctionWrapper;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootTableWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootPool")
public class ZenLootPoolWrapper
implements ZenLootTableWrapper.LootTableTweaker {
    private static final String ENTRY_NAME_PREFIX = "loottweaker#";
    private static final int DEFAULT_QUALITY = 0;
    private static final LootEntry[] NO_ENTRIES = new LootEntry[0];
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private static final LootFunction[] NO_FUNCTIONS = new LootFunction[0];
    private final ErrorHandler errorHandler;
    private final DataParser loggingParser;
    private final List<LootPoolTweaker> tweakers = new ArrayList<LootPoolTweaker>();
    private final ResourceLocation parentTableId;
    private final String id;
    private int nextEntryNameId = 1;

    public ZenLootPoolWrapper(ErrorHandler errorHandler, String id, ResourceLocation parentTableId) {
        this.errorHandler = errorHandler;
        this.loggingParser = this.createDataParser(errorHandler);
        this.id = id;
        this.parentTableId = parentTableId;
    }

    private DataParser createDataParser(ErrorHandler errorHandler) {
        return new DataParser(LootTableManagerAccessors.getGsonInstance(), e -> errorHandler.error(e.getMessage()));
    }

    @ZenMethod
    public void addConditionsHelper(ZenLootConditionWrapper[] conditionWrappers) {
        List parsedConditions = Arrays.stream(conditionWrappers).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).collect(Collectors.toList());
        this.enqueueTweaker(pool -> LootPoolAccessors.getConditions(pool).addAll(parsedConditions), "Added %d conditions to pool '%s' of table '%s'", parsedConditions.size(), this.id, this.parentTableId);
    }

    @ZenMethod
    public void addConditionsJson(IData[] conditionsJson) {
        List parsedConditions = Arrays.stream(conditionsJson).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).collect(Collectors.toList());
        this.enqueueTweaker(pool -> LootPoolAccessors.getConditions(pool).addAll(parsedConditions), "Added %d conditions to pool '%s' of table '%s'", parsedConditions.size(), this.id, this.parentTableId);
    }

    @ZenMethod
    public void clearConditions() {
        this.enqueueTweaker(pool -> LootPoolAccessors.getConditions(pool).clear(), "Queuing all conditions of pool %s in table %s for removal", this.id, this.parentTableId);
    }

    @ZenMethod
    public void clearEntries() {
        this.enqueueTweaker(pool -> LootPoolAccessors.getEntries(pool).clear(), "Queuing all entries of pool %s in table %s for removal", this.id, this.parentTableId);
    }

    @ZenMethod
    public void removeEntry(String entryName) {
        this.enqueueTweaker(pool -> {
            if (pool.removeEntry(entryName) == null) {
                this.errorHandler.error("No entry with name %s exists in pool %s", entryName, this.id);
            }
        }, "Queueing entry %s of pool %s for removal", entryName, this.id);
    }

    @ZenMethod
    public void addItemEntry(IItemStack stack, int weight, @Optional String name) {
        this.addItemEntryInternal(stack, weight, 0, NO_FUNCTIONS, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addItemEntry(IItemStack stack, int weight, int quality, @Optional String name) {
        this.addItemEntryInternal(stack, weight, quality, NO_FUNCTIONS, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addItemEntryHelper(IItemStack stack, int weight, int quality, ZenLootFunctionWrapper[] functions, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addItemEntryInternal(stack, weight, quality, (LootFunction[])Arrays.stream(functions).filter(ZenLootFunctionWrapper::isValid).map(ZenLootFunctionWrapper::unwrap).toArray(LootFunction[]::new), (LootCondition[])Arrays.stream(conditions).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).toArray(LootCondition[]::new), name);
    }

    @ZenMethod
    public void addItemEntryJson(IItemStack stack, int weight, int quality, IData[] functions, IData[] conditions, @Optional String name) {
        LootFunction[] parsedFunctions = (LootFunction[])Arrays.stream(functions).map(c -> this.loggingParser.parse((IData)c, LootFunction.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootFunction[]::new);
        LootCondition[] parsedConditions = (LootCondition[])Arrays.stream(conditions).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootCondition[]::new);
        this.addItemEntryInternal(stack, weight, quality, parsedFunctions, parsedConditions, name);
    }

    private void addItemEntryInternal(IItemStack stack, int weight, int quality, LootFunction[] functions, LootCondition[] conditions, @Optional String name) {
        if (stack == null) {
            return;
        }
        String entryName = name != null ? name : this.generateName();
        LootEntryItem entry = new LootEntryItem(CraftTweakerMC.getItemStack((IItemStack)stack).func_77973_b(), weight, quality, this.addStackFunctions(stack, functions), conditions, entryName);
        this.addEntry((LootEntry)entry, "Queued item entry '%s' for addition to pool %s of table %s", entryName, this.id, this.parentTableId);
    }

    private LootFunction[] addStackFunctions(IItemStack iStack, LootFunction[] existingFunctions) {
        ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)iStack);
        boolean sizeFuncExists = false;
        boolean damageFuncExists = false;
        boolean nbtFuncExists = false;
        for (LootFunction lootFunction : existingFunctions) {
            if (lootFunction instanceof SetCount) {
                sizeFuncExists = true;
            }
            if (lootFunction instanceof SetDamage || lootFunction instanceof SetMetadata) {
                damageFuncExists = true;
            }
            if (!(lootFunction instanceof SetNBT)) continue;
            nbtFuncExists = true;
        }
        ArrayList functionsOut = Lists.newArrayListWithCapacity((int)(existingFunctions.length + 3));
        Collections.addAll(functionsOut, existingFunctions);
        if (iStack.getAmount() > 1 && !sizeFuncExists) {
            functionsOut.add(new SetCount(NO_CONDITIONS, new RandomValueRange((float)iStack.getAmount())));
        }
        if (iStack.getDamage() > 0 && !damageFuncExists) {
            functionsOut.add(stack.func_77984_f() ? new SetDamage(NO_CONDITIONS, new RandomValueRange((float)stack.func_77952_i() / (float)stack.func_77958_k())) : new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)iStack.getDamage())));
        }
        if (iStack.getTag() != DataMap.EMPTY && !nbtFuncExists) {
            functionsOut.add(new SetNBT(NO_CONDITIONS, CraftTweakerMC.getNBTCompound((IData)iStack.getTag())));
        }
        return functionsOut.toArray(NO_FUNCTIONS);
    }

    @ZenMethod
    public void addLootTableEntry(String tableName, int weight, @Optional String name) {
        this.addLootTableEntry(tableName, weight, 0, name);
    }

    @ZenMethod
    public void addLootTableEntry(String tableName, int weight, int quality, @Optional String name) {
        this.addLootTableEntryInternal(tableName, weight, quality, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addLootTableEntryHelper(String tableName, int weight, int quality, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addLootTableEntryInternal(tableName, weight, quality, (LootCondition[])Arrays.stream(conditions).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).toArray(LootCondition[]::new), name);
    }

    @ZenMethod
    public void addLootTableEntryJson(String tableName, int weight, int quality, IData[] conditions, @Optional String name) {
        LootCondition[] parsedConditions = (LootCondition[])Arrays.stream(conditions).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootCondition[]::new);
        this.addLootTableEntryInternal(tableName, weight, quality, parsedConditions, name);
    }

    private void addLootTableEntryInternal(String tableName, int weight, int quality, LootCondition[] conditions, @Optional String name) {
        String entryName = name != null ? name : this.generateName();
        this.addEntry((LootEntry)new LootEntryTable(new ResourceLocation(tableName), weight, quality, conditions, entryName), "Queued loot table entry '%s' for addition to pool %s of table %s", entryName, this.id, this.parentTableId);
    }

    @ZenMethod
    public void addEmptyEntry(int weight, @Optional String name) {
        this.addEmptyEntry(weight, 0, name);
    }

    @ZenMethod
    public void addEmptyEntry(int weight, int quality, @Optional String name) {
        this.addEmptyEntryInternal(weight, quality, NO_CONDITIONS, name);
    }

    @ZenMethod
    public void addEmptyEntryHelper(int weight, int quality, ZenLootConditionWrapper[] conditions, @Optional String name) {
        this.addEmptyEntryInternal(weight, quality, (LootCondition[])Arrays.stream(conditions).filter(ZenLootConditionWrapper::isValid).map(ZenLootConditionWrapper::unwrap).toArray(LootCondition[]::new), name);
    }

    @ZenMethod
    public void addEmptyEntryJson(int weight, int quality, IData[] conditions, @Optional String name) {
        LootCondition[] parsedConditions = (LootCondition[])Arrays.stream(conditions).map(c -> this.loggingParser.parse((IData)c, LootCondition.class)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).toArray(LootCondition[]::new);
        this.addEmptyEntryInternal(weight, quality, parsedConditions, name);
    }

    private void addEmptyEntryInternal(int weight, int quality, LootCondition[] conditions, @Optional String name) {
        String entryName = name != null ? name : this.generateName();
        this.addEntry((LootEntry)new LootEntryEmpty(weight, quality, conditions, entryName), "Queued empty entry '%s' for addition to pool %s of table %s", entryName, this.id, this.parentTableId);
    }

    private String generateName() {
        return ENTRY_NAME_PREFIX + this.nextEntryNameId++;
    }

    @ZenMethod
    public void setRolls(float minRolls, float maxRolls) {
        this.enqueueTweaker(pool -> pool.setRolls(new RandomValueRange(minRolls, maxRolls)), "Rolls of pool %s in table %s will be set to (%f, %f)", this.id, this.parentTableId, Float.valueOf(minRolls), Float.valueOf(maxRolls));
    }

    @ZenMethod
    public void setBonusRolls(float minBonusRolls, float maxBonusRolls) {
        this.enqueueTweaker(pool -> pool.setBonusRolls(new RandomValueRange(minBonusRolls, maxBonusRolls)), "Bonus rolls of pool %s in table %s will be set to (%f, %f)", this.id, this.parentTableId, Float.valueOf(minBonusRolls), Float.valueOf(maxBonusRolls));
    }

    private void addEntry(LootEntry entry, String format, Object ... args) {
        this.enqueueTweaker(pool -> {
            try {
                pool.addEntry(entry);
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("duplicate")) {
                    this.errorHandler.error("Cannot add entry '%s' to pool '%s' of table '%s'. Entry names must be unique within their pool.", entry.getEntryName(), pool.getName(), this.parentTableId);
                }
                throw e;
            }
        }, format, args);
    }

    private void enqueueTweaker(LootPoolTweaker tweaker, String format, Object ... args) {
        this.tweakers.add(tweaker);
        CraftTweakerAPI.logInfo((String)String.format(format, args));
    }

    @Override
    public void tweak(LootTable table) {
        LootPool existing = table.getPool(this.id);
        if (existing != null) {
            this.tweak(existing);
        } else {
            RandomValueRange dummyRange = new RandomValueRange(1.0f);
            LootPool newPool = new LootPool(NO_ENTRIES, NO_CONDITIONS, dummyRange, dummyRange, this.id);
            this.tweak(newPool);
            table.addPool(newPool);
            CraftTweakerAPI.logInfo((String)String.format("Added new pool %s to table %s", this.id, this.parentTableId));
        }
    }

    public void tweak(LootPool pool) {
        for (LootPoolTweaker tweaker : this.tweakers) {
            tweaker.tweak(pool);
        }
    }

    @FunctionalInterface
    public static interface LootPoolTweaker {
        public void tweak(LootPool var1);
    }
}

