/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.littletiles.client.gui.handler.LittleGuiHandler;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiStructureOverview
extends SubGui {
    public LittleTile tile;

    public SubGuiStructureOverview(LittleTile tile) {
        this.tile = tile;
    }

    public void createControls() {
        if (!this.tile.isChildOfStructure()) {
            return;
        }
        final LittleStructure structure = this.tile.connection.getStructureWithoutLoading();
        if (structure == null) {
            this.controls.add(new GuiLabel(ChatFormatting.WHITE + "status: " + ChatFormatting.YELLOW + "pending", 0, 3));
            this.controls.add(new GuiButton("connect", 90, 0){

                public void onClicked(int x, int y, int button) {
                    SubGuiStructureOverview.this.tile.isConnectedToStructure();
                    SubGuiStructureOverview.this.controls.clear();
                    SubGuiStructureOverview.this.createControls();
                    SubGuiStructureOverview.this.refreshControls();
                }
            });
        } else {
            this.controls.add(new GuiLabel(ChatFormatting.WHITE + "status: " + ChatFormatting.DARK_GREEN + (structure.name != null ? structure.name : structure.type.id) + ChatFormatting.WHITE + ", " + structure.count() + " tile(s)", 0, 3));
            if (structure.parent == null) {
                this.controls.add(new GuiLabel(ChatFormatting.WHITE + "no parent", 0, 20));
            } else {
                this.controls.add(new GuiLabel(ChatFormatting.WHITE + "parent: " + (structure.parent.getStructureWithoutLoading() == null ? ChatFormatting.YELLOW + "pending" : ChatFormatting.DARK_GREEN + (structure.parent.getStructureWithoutLoading().name != null ? structure.parent.getStructureWithoutLoading().name : structure.parent.getStructureWithoutLoading().type.id) + ChatFormatting.WHITE + ", " + structure.parent.getStructureWithoutLoading().count() + " tile(s)"), 0, 20));
                if (structure.parent.getStructureWithoutLoading() == null) {
                    this.controls.add(new GuiButton("connect", 130, 17){

                        public void onClicked(int x, int y, int button) {
                            structure.parent.isConnected(SubGuiStructureOverview.this.tile.te.func_145831_w());
                            SubGuiStructureOverview.this.controls.clear();
                            SubGuiStructureOverview.this.createControls();
                            SubGuiStructureOverview.this.refreshControls();
                        }
                    });
                } else {
                    this.controls.add(new GuiButton("open", 140, 17){

                        public void onClicked(int x, int y, int button) {
                            LittleGuiHandler.openGui("structureoverview", new NBTTagCompound(), this.getPlayer(), structure.parent.getStructureWithoutLoading().getMainTile());
                        }
                    });
                }
            }
            this.controls.add(new GuiLabel(ChatFormatting.WHITE + "" + structure.children.size() + " child" + (structure.children.size() != 1 ? "ren" : ""), 0, 40));
            GuiScrollBox scrollBox = new GuiScrollBox(this.name, 3, 55, 165, 100);
            scrollBox.scaleFactor = 0.9f;
            int i = 0;
            for (final IStructureChildConnector child : structure.children) {
                scrollBox.addControl((GuiControl)new GuiLabel("id: " + child.getChildID() + ", " + (child.getStructureWithoutLoading() == null ? ChatFormatting.YELLOW + "pending" : ChatFormatting.DARK_GREEN + (child.getStructureWithoutLoading().name != null ? child.getStructureWithoutLoading().name : child.getStructureWithoutLoading().type.id) + ChatFormatting.WHITE + ", " + child.getStructureWithoutLoading().count() + " tile(s)"), 0, 5 + 20 * i));
                if (child.getStructureWithoutLoading() == null) {
                    scrollBox.addControl((GuiControl)new GuiButton("connect", 115, 2 + 20 * i){

                        public void onClicked(int x, int y, int button) {
                            child.isConnected(SubGuiStructureOverview.this.tile.te.func_145831_w());
                            SubGuiStructureOverview.this.controls.clear();
                            SubGuiStructureOverview.this.createControls();
                            SubGuiStructureOverview.this.refreshControls();
                        }
                    });
                } else {
                    scrollBox.addControl((GuiControl)new GuiButton("open", 128, 2 + 20 * i){

                        public void onClicked(int x, int y, int button) {
                            LittleGuiHandler.openGui("structureoverview", new NBTTagCompound(), this.getPlayer(), child.getStructureWithoutLoading().getMainTile());
                        }
                    });
                }
                ++i;
            }
            this.controls.add(scrollBox);
        }
    }
}

