/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.littletiles.client.gui.controls.GuiSlotControlBlockIngredient;
import com.creativemd.littletiles.common.item.ItemBlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotControlBlockIngredient
extends SlotControl {
    public SlotControlBlockIngredient(Slot slot) {
        super(slot);
    }

    public BlockIngredientEntry getIngredient() {
        return ItemBlockIngredient.loadIngredient(this.slot.func_75211_c());
    }

    @SideOnly(value=Side.CLIENT)
    public GuiControl createGuiControl() {
        GuiSlotControlBlockIngredient control = new GuiSlotControlBlockIngredient(this.slot.field_75223_e, this.slot.field_75221_f, this);
        return control;
    }

    public boolean canMergeIntoInventory(Slot mergeSlot) {
        return super.canMergeIntoInventory(mergeSlot) && !mergeSlot.field_75224_c.func_70005_c_().equals("input");
    }

    public boolean isEntireBlock() {
        BlockIngredientEntry entry = this.getIngredient();
        return entry != null && entry.value >= 1.0;
    }

    public void transferIntoOtherInventory(int amount) {
        BlockIngredientEntry entry;
        if (!this.isEntireBlock()) {
            super.transferIntoOtherInventory(amount);
        }
        if ((entry = this.getIngredient()) == null) {
            return;
        }
        ItemStack stack = entry.getItemStack();
        amount = Math.min(amount, (int)entry.value);
        stack.func_190920_e(amount);
        this.mergeToOtherInventory(stack, false);
        if (!stack.func_190926_b()) {
            this.mergeToOtherInventory(stack, true);
        }
        if (!stack.func_190926_b()) {
            amount -= stack.func_190916_E();
        }
        entry.value -= (double)amount;
        ItemBlockIngredient.saveIngredient(this.slot.func_75211_c(), entry);
    }

    public void takeStack(boolean leftClick, InventoryPlayer inventoryplayer) {
        if (!this.isEntireBlock()) {
            super.takeStack(leftClick, inventoryplayer);
            return;
        }
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        BlockIngredientEntry entry = this.getIngredient();
        ItemStack slotItem = entry.getItemStack();
        slotItem.func_190920_e((int)entry.value);
        if (leftClick) {
            int stackSize = Math.min(Math.min(slotItem.func_190916_E(), slotItem.func_77976_d()), slotItem.func_190916_E());
            slotItem.func_190920_e(stackSize);
            inventoryplayer.func_70437_b(slotItem);
            entry.value -= (double)slotItem.func_190916_E();
            ItemBlockIngredient.saveIngredient(this.slot.func_75211_c(), entry);
        }
    }
}

