/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleBoxes
extends ArrayList<LittleBox>
implements IGridBased {
    public BlockPos pos;
    public LittleGridContext context;

    public LittleBoxes(BlockPos pos, LittleGridContext context) {
        this.pos = pos;
        this.context = context;
    }

    public void addBox(LittleTile tile) {
        this.addBox(tile.getContext(), tile.te.func_174877_v(), tile.box.copy());
    }

    public void addBox(LittleGridContext context, BlockPos pos, LittleBox box) {
        if (this.context != context) {
            if (this.context.size > context.size) {
                box.convertTo(context, this.context);
                context = this.context;
            } else {
                this.convertTo(context);
            }
        }
        box.add(new LittleVec(context, (Vec3i)pos.func_177973_b((Vec3i)this.pos)));
        this.add(box);
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        for (LittleBox box : this) {
            box.convertTo(this.context, to);
        }
        this.context = to;
    }

    @Override
    public void convertToSmallest() {
        int size = LittleGridContext.minSize;
        for (LittleBox box : this) {
            size = Math.max(size, box.getSmallestContext(this.context));
        }
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public LittleBox getSurroundingBox() {
        if (this.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : this) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public HashMapList<BlockPos, LittleBox> split() {
        HashMapList map = new HashMapList();
        for (LittleBox box : this) {
            box.split(this.context, this.pos, (HashMapList<BlockPos, LittleBox>)map);
        }
        return map;
    }

    public void flip(EnumFacing.Axis axis, LittleAbsoluteBox absoluteBox) {
        this.ensureContext(absoluteBox, () -> {
            LittleVec center = absoluteBox.getDoubledCenter(this.pos);
            for (LittleBox box : this) {
                box.flipBox(axis, center);
            }
        });
    }

    public LittleBoxes copy() {
        LittleBoxes boxes = new LittleBoxes(this.pos, this.context);
        boxes.addAll(this);
        return boxes;
    }
}

