/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.animation;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.util.animation.AnimationKey;
import java.util.List;
import javax.vecmath.Vector3d;
import net.minecraft.nbt.NBTTagCompound;

public class AnimationState {
    private PairList<AnimationKey, Double> values = new PairList();

    public double get(AnimationKey key) {
        Double value = (Double)this.values.getValue((Object)key);
        if (value == null) {
            return key.getDefault();
        }
        return value;
    }

    public AnimationState set(AnimationKey key, double value) {
        Pair pair = this.values.getPair((Object)key);
        if (key.getDefault() == value) {
            if (pair != null) {
                this.values.removeKey((Object)key);
            }
            return this;
        }
        if (pair != null) {
            pair.setValue((Object)value);
        } else {
            this.values.add((Object)key, (Object)value);
        }
        return this;
    }

    public AnimationState(NBTTagCompound nbt) {
        for (AnimationKey key : AnimationKey.getKeys()) {
            if (!nbt.func_74764_b(key.name)) continue;
            this.values.add((Object)key, (Object)nbt.func_74769_h(key.name));
        }
    }

    public AnimationState() {
    }

    public Vector3d getRotation() {
        return new Vector3d(this.get(AnimationKey.rotX), this.get(AnimationKey.rotY), this.get(AnimationKey.rotZ));
    }

    public Vector3d getOffset() {
        return new Vector3d(this.get(AnimationKey.offX), this.get(AnimationKey.offY), this.get(AnimationKey.offZ));
    }

    public void clear() {
        this.values.clear();
    }

    public List<AnimationKey> keys() {
        return this.values.keys();
    }

    public PairList<AnimationKey, Double> getValues() {
        return this.values;
    }

    public boolean isAligned() {
        for (Pair pair : this.values) {
            if (((AnimationKey)pair.key).isAligned((Double)pair.value)) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        for (Pair pair : this.values) {
            nbt.func_74780_a(((AnimationKey)pair.key).name, ((Double)pair.value).doubleValue());
        }
        return nbt;
    }

    public void transform(Rotation rotation) {
        PairList newPairs = new PairList();
        for (Pair pair : this.values) {
            Pair<AnimationKey, Double> result = ((AnimationKey)pair.key).transform(rotation, (Double)pair.value);
            if (result != null) {
                newPairs.add(result);
                continue;
            }
            newPairs.add(pair);
        }
        this.values = newPairs;
    }
}

