/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.ingredient;

import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredientBase;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class LittleIngredients
extends LittleIngredientBase<LittleIngredients>
implements Iterable<LittleIngredient> {
    protected LittleIngredient[] content = new LittleIngredient[LittleIngredient.typeCount()];

    public LittleIngredients(LittleIngredient ... ingredients) {
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i] == null) continue;
            this.set(ingredients[i].getClass(), ingredients[i]);
        }
    }

    public LittleIngredients() {
    }

    public boolean contains(Class<? extends LittleIngredient> type) {
        LittleIngredient ingredient = this.content[LittleIngredient.indexOf(type)];
        return ingredient != null && !ingredient.isEmpty();
    }

    public LittleIngredient[] getContent() {
        return this.content;
    }

    public <T extends LittleIngredient> T get(Class<T> type) {
        return (T)this.content[LittleIngredient.indexOf(type)];
    }

    public void set(Class<? extends LittleIngredient> type, LittleIngredient ingredient) {
        this.content[LittleIngredient.indexOf(type)] = ingredient;
    }

    @Override
    public LittleIngredient add(LittleIngredient ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        int index = LittleIngredient.indexOf(ingredient);
        LittleIngredient item = this.content[index];
        if (item != null) {
            return item.add(ingredient);
        }
        if (!this.canAddNewIngredients()) {
            return ingredient;
        }
        this.content[index] = ingredient;
        return null;
    }

    @Override
    public LittleIngredient sub(LittleIngredient ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        int index = LittleIngredient.indexOf(ingredient);
        LittleIngredient item = this.content[index];
        if (item != null) {
            return item.sub(ingredient);
        }
        return ingredient;
    }

    protected void assignContent(LittleIngredients toAssign) {
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = toAssign.content[i] != null ? toAssign.content[i].copy() : null;
        }
    }

    @Override
    public LittleIngredients copy() {
        LittleIngredients ingredients = new LittleIngredients();
        ingredients.assignContent(this);
        return ingredients;
    }

    @Override
    public LittleIngredients add(LittleIngredients ingredient) {
        if (ingredient == null) {
            return null;
        }
        LittleIngredients remains = null;
        for (int i = 0; i < this.content.length; ++i) {
            LittleIngredient existing = this.content[i];
            LittleIngredient toAdd = ingredient.content[i];
            if (toAdd == null || toAdd.isEmpty()) continue;
            if (existing == null) {
                if (this.canAddNewIngredients()) {
                    this.content[i] = toAdd;
                    continue;
                }
                if (remains == null) {
                    remains = new LittleIngredients();
                }
                remains.content[i] = toAdd;
                continue;
            }
            LittleIngredient remain = existing.add(toAdd);
            if (remain == null) continue;
            if (remains == null) {
                remains = new LittleIngredients();
            }
            remains.content[i] = remain;
        }
        return remains;
    }

    @Override
    public LittleIngredients sub(LittleIngredients ingredient) {
        if (ingredient == null) {
            return null;
        }
        LittleIngredients remains = null;
        for (int i = 0; i < this.content.length; ++i) {
            LittleIngredient existing = this.content[i];
            LittleIngredient toSub = ingredient.content[i];
            if (toSub == null || toSub.isEmpty()) continue;
            if (existing == null) {
                if (remains == null) {
                    remains = new LittleIngredients();
                }
                remains.content[i] = toSub;
                continue;
            }
            LittleIngredient remain = existing.sub(toSub);
            if (remain == null) continue;
            if (remains == null) {
                remains = new LittleIngredients();
            }
            remains.content[i] = remain;
        }
        return remains;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null || this.content[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void scale(int count) {
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null || this.content[i].isEmpty()) continue;
            this.content[i].scale(count);
        }
    }

    public int getMinimumCount(LittleIngredients other, int availableCount) {
        int count = -1;
        for (int i = 0; i < this.content.length; ++i) {
            LittleIngredient existing = this.content[i];
            LittleIngredient toSub = other.content[i];
            if (existing == null || existing.isEmpty() || toSub == null || toSub.isEmpty()) continue;
            count = Math.max(count, existing.getMinimumCount(toSub, availableCount));
        }
        return count;
    }

    public List<ItemStack> handleOverflow() throws NotEnoughIngredientsException.NotEnoughSpaceException {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null || this.content[i].isEmpty()) continue;
            stacks.addAll(LittleIngredient.handleOverflow(this.content[i]));
        }
        return stacks;
    }

    protected boolean canAddNewIngredients() {
        return true;
    }

    protected boolean removeEmptyIngredients() {
        return true;
    }

    @Override
    public Iterator<LittleIngredient> iterator() {
        return new Iterator<LittleIngredient>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                for (int nextIndex = this.index + 1; nextIndex < LittleIngredients.this.content.length; ++nextIndex) {
                    if (LittleIngredients.this.content[nextIndex] == null || LittleIngredients.this.content[nextIndex].isEmpty()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public LittleIngredient next() {
                ++this.index;
                while (this.index < LittleIngredients.this.content.length) {
                    if (LittleIngredients.this.content[this.index] != null && !LittleIngredients.this.content[this.index].isEmpty()) {
                        return LittleIngredients.this.content[this.index];
                    }
                    ++this.index;
                }
                throw new RuntimeException("Iterator reached end of ingredients. Something has gone wrong!");
            }
        };
    }
}

