/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.outdated;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.entity.old.EntityOldDoorAnimation;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

@Deprecated
public abstract class OldDoorTransformation {
    private static HashMap<String, Class<? extends OldDoorTransformation>> transformationTypes = new HashMap();

    public static void registerTransformationType(String id, Class<? extends OldDoorTransformation> classType) {
        if (transformationTypes.containsKey(id)) {
            throw new IllegalArgumentException("id '" + id + "' is already taken");
        }
        transformationTypes.put(id, classType);
    }

    public static String getIDFromClass(Class<? extends OldDoorTransformation> classType) {
        for (Map.Entry<String, Class<? extends OldDoorTransformation>> type : transformationTypes.entrySet()) {
            if (type.getValue() != classType) continue;
            return type.getKey();
        }
        return "";
    }

    public static OldDoorTransformation loadFromNBT(NBTTagCompound nbt) {
        Class<? extends OldDoorTransformation> type = transformationTypes.get(nbt.func_74779_i("id"));
        if (type != null) {
            try {
                OldDoorTransformation transformation = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                transformation.readFromNBT(nbt);
                return transformation;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(type.getClass() + " does not contain an empty constructor.");
            }
        }
        throw new IllegalArgumentException("id '" + nbt.func_74779_i("id") + "' could not be loaded.");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.writeToNBTExtra(nbt);
        nbt.func_74778_a("id", OldDoorTransformation.getIDFromClass(this.getClass()));
        return nbt;
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    protected abstract void readFromNBT(NBTTagCompound var1);

    public abstract void performTransformation(EntityOldDoorAnimation var1, double var2);

    public abstract boolean equals(Object var1);

    static {
        OldDoorTransformation.registerTransformationType("ordinary", RotateDoorTransformation.class);
        OldDoorTransformation.registerTransformationType("sliding", SlideDoorTransformation.class);
    }

    @Deprecated
    public static class SlideDoorTransformation
    extends OldDoorTransformation {
        public EnumFacing direction;
        public int distance;
        public LittleGridContext context;

        public SlideDoorTransformation() {
        }

        public SlideDoorTransformation(EnumFacing direction, LittleGridContext context, int distance) {
            this.direction = direction;
            this.distance = distance;
            this.context = context;
        }

        @Override
        protected void writeToNBTExtra(NBTTagCompound nbt) {
            nbt.func_74768_a("direction", this.direction.ordinal());
            nbt.func_74768_a("distance", this.distance);
            this.context.set(nbt);
        }

        @Override
        protected void readFromNBT(NBTTagCompound nbt) {
            this.direction = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
            this.distance = nbt.func_74762_e("distance");
            this.context = LittleGridContext.get(nbt);
        }

        @Override
        public void performTransformation(EntityOldDoorAnimation animation, double progress) {
            double pushDistance = (double)this.distance * this.context.pixelSize * (1.0 - progress);
            switch (this.direction) {
                case EAST: {
                    animation.moveXTo((double)animation.getAxisPos().func_177958_n() - pushDistance);
                    break;
                }
                case WEST: {
                    animation.moveXTo((double)animation.getAxisPos().func_177958_n() + pushDistance);
                    break;
                }
                case UP: {
                    animation.moveYTo((double)animation.getAxisPos().func_177956_o() - pushDistance);
                    break;
                }
                case DOWN: {
                    animation.moveYTo((double)animation.getAxisPos().func_177956_o() + pushDistance);
                    break;
                }
                case SOUTH: {
                    animation.moveZTo((double)animation.getAxisPos().func_177952_p() - pushDistance);
                    break;
                }
                case NORTH: {
                    animation.moveZTo((double)animation.getAxisPos().func_177952_p() + pushDistance);
                    break;
                }
            }
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof SlideDoorTransformation) {
                return ((SlideDoorTransformation)object).direction == this.direction && ((SlideDoorTransformation)object).distance == this.distance && ((SlideDoorTransformation)object).context == this.context;
            }
            return false;
        }
    }

    @Deprecated
    public static class RotateDoorTransformation
    extends OldDoorTransformation {
        public Rotation rotation;

        public RotateDoorTransformation() {
        }

        public RotateDoorTransformation(Rotation rotation) {
            this.rotation = rotation;
        }

        @Override
        public void performTransformation(EntityOldDoorAnimation animation, double progress) {
            switch (this.rotation) {
                case X_CLOCKWISE: {
                    animation.rotXTo(-90.0 + progress * 90.0);
                    break;
                }
                case X_COUNTER_CLOCKWISE: {
                    animation.rotXTo((1.0 - progress) * 90.0);
                    break;
                }
                case Y_CLOCKWISE: {
                    animation.rotYTo(-90.0 + progress * 90.0);
                    break;
                }
                case Y_COUNTER_CLOCKWISE: {
                    animation.rotYTo((1.0 - progress) * 90.0);
                    break;
                }
                case Z_CLOCKWISE: {
                    animation.rotZTo(-90.0 + progress * 90.0);
                    break;
                }
                case Z_COUNTER_CLOCKWISE: {
                    animation.rotZTo((1.0 - progress) * 90.0);
                }
            }
        }

        @Override
        protected void writeToNBTExtra(NBTTagCompound nbt) {
            nbt.func_74768_a("rot", this.rotation.ordinal());
        }

        @Override
        protected void readFromNBT(NBTTagCompound nbt) {
            this.rotation = Rotation.values()[nbt.func_74762_e("rot")];
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof RotateDoorTransformation) {
                return ((RotateDoorTransformation)object).rotation == this.rotation;
            }
            return false;
        }
    }
}

