/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.widgets.IContainer;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WContainer
implements IContainer {
    protected List<IWidget> widgets = new ArrayList<IWidget>();

    public void add(IWidget w) {
        this.widgets.add(w);
    }

    @Override
    public void add(IWidget ... w) {
        if (w.length == 1) {
            this.widgets.add(w[0]);
        } else {
            this.widgets.addAll(Arrays.asList(w));
        }
    }

    @Override
    public void remove(IWidget ... w) {
        if (w.length == 1) {
            this.widgets.remove(w[0]);
        } else {
            this.widgets.removeAll(Arrays.asList(w));
        }
    }

    @Override
    public void clear() {
        this.widgets.clear();
    }

    public boolean contains(IWidget w) {
        return this.widgets.contains(w);
    }

    @Override
    public void onDraw(JecaGui gui, int mouseX, int mouseY) {
        this.widgets.forEach(widget -> widget.onDraw(gui, mouseX, mouseY));
    }

    @Override
    public boolean onClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        return new Utilities.ReversedIterator<IWidget>(this.widgets).stream().anyMatch(i -> i.onClicked(gui, xMouse, yMouse, button));
    }

    @Override
    public boolean onKey(JecaGui gui, char ch, int code) {
        return new Utilities.ReversedIterator<IWidget>(this.widgets).stream().anyMatch(i -> i.onKey(gui, ch, code));
    }

    @Override
    public boolean onScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
        return new Utilities.ReversedIterator<IWidget>(this.widgets).stream().anyMatch(i -> i.onScroll(gui, xMouse, yMouse, diff));
    }

    @Override
    public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
        return new Utilities.ReversedIterator<IWidget>(this.widgets).stream().anyMatch(i -> i.onTooltip(gui, xMouse, yMouse, tooltip));
    }

    @Override
    @Nullable
    public ILabel getLabelUnderMouse(int xMouse, int yMouse) {
        return new Utilities.ReversedIterator<IWidget>(this.widgets).stream().map(i -> i.getLabelUnderMouse(xMouse, yMouse)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

