/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.blocks;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankMaterial;
import net.zarathul.simplefluidtanks.blocks.WrenchableBlock;
import net.zarathul.simplefluidtanks.blocks.blockstate.StringProperty;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class TankBlock
extends WrenchableBlock {
    public static final IUnlistedProperty<Integer> FluidLevel = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"fluidLevel", (int)0, (int)16));
    public static final IUnlistedProperty<String> FluidName = new StringProperty("fluidName");
    public static final IUnlistedProperty<Boolean> CullFluidTop = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"cullFluidTop"));
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private final HashSet<BlockPos> ignoreBlockBreakCoords;

    public TankBlock() {
        super(TankMaterial.tankMaterial);
        this.setRegistryName("tankBlock");
        this.func_149663_c("tankBlock");
        this.func_149647_a(SimpleFluidTanks.creativeTab);
        this.func_149711_c(Config.tankBlockHardness);
        this.func_149752_b(Config.tankBlockResistance);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)));
        this.ignoreBlockBreakCoords = new HashSet();
    }

    protected BlockStateContainer func_180661_e() {
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{FluidLevel, FluidName, CullFluidTop};
        IProperty[] listedProperties = new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TankBlockEntity tankEntity = Utils.getTileEntityAt(world, TankBlockEntity.class, pos);
        TankBlockEntity tankAbove = Utils.getTileEntityAt(world, TankBlockEntity.class, pos.func_177984_a());
        if (tankEntity != null && tankEntity.isPartOfTank()) {
            Fluid tankFluid = tankEntity.getFluid();
            int fluidLevel = tankEntity.getFillLevel();
            boolean tankAboveIsEmpty = true;
            boolean sameValve = false;
            if (tankAbove != null) {
                tankAboveIsEmpty = tankAbove.isEmpty();
                ValveBlockEntity valve = tankEntity.getValve();
                ValveBlockEntity valveAbove = tankAbove.getValve();
                sameValve = valve != null && valveAbove != null && valve == valveAbove;
            }
            boolean cullFluidTop = !tankAboveIsEmpty && sameValve;
            return extendedState.withProperty(FluidName, (Object)(tankFluid != null ? tankFluid.getName() : "")).withProperty(FluidLevel, (Object)fluidLevel).withProperty(CullFluidTop, (Object)cullFluidTop);
        }
        return extendedState.withProperty(FluidName, (Object)"").withProperty(FluidLevel, (Object)0).withProperty(CullFluidTop, (Object)false);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TankBlockEntity tankEntity = Utils.getTileEntityAt(world, TankBlockEntity.class, pos);
        if (tankEntity != null && tankEntity.isPartOfTank()) {
            return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(tankEntity.isConnected(EnumFacing.DOWN))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(tankEntity.isConnected(EnumFacing.UP))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(tankEntity.isConnected(EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(tankEntity.isConnected(EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(tankEntity.isConnected(EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(tankEntity.isConnected(EnumFacing.EAST)));
        }
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TankBlockEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TankBlockEntity adjacentTankEntity = Utils.getTileEntityAt(blockAccess, TankBlockEntity.class, pos.func_177972_a(side));
        TankBlockEntity tankEntity = Utils.getTileEntityAt(blockAccess, TankBlockEntity.class, pos);
        ValveBlockEntity adjacentTankValve = adjacentTankEntity != null ? adjacentTankEntity.getValve() : null;
        ValveBlockEntity tankValve = tankEntity != null ? tankEntity.getValve() : null;
        return adjacentTankEntity == null || adjacentTankValve != tankValve;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149698_L() {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            if (this.ignoreBlockBreakCoords.contains(pos)) {
                this.ignoreBlockBreakCoords.remove(pos);
                return;
            }
            ValveBlockEntity valveEntity = Utils.getValve((IBlockAccess)world, pos);
            if (valveEntity != null) {
                valveEntity.disbandMultiblock();
            }
        }
    }

    @Override
    protected void handleToolWrenchClick(World world, BlockPos pos, EntityPlayer player, ItemStack equippedItemStack) {
        if (player.func_70093_af()) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)world, TankBlockEntity.class, pos);
            ValveBlockEntity valveEntity = null;
            if (tankEntity != null && tankEntity.isPartOfTank()) {
                valveEntity = tankEntity.getValve();
                this.ignoreBlockBreakCoords.add(pos);
            }
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
            if (valveEntity != null) {
                valveEntity.formMultiblock();
            }
        }
    }
}

