/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.value;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.NullAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.ChangeListener;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMValueInt {
    private int value;
    @Nullable
    private final ChangeListener.Int change;
    private Animatable animatable = new Animatable();

    public RMValueInt(int initialValue) {
        this.value = initialValue;
        this.change = null;
    }

    public RMValueInt(int initialValue, @NotNull ChangeListener.Int change) {
        this.value = initialValue;
        this.change = change;
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        GuiAnimator.getCurrent().add(this.animatable);
        this.value = value;
    }

    public int getValue(Object thisRef, KProperty property) {
        return this.value;
    }

    public void setValue(Object thisRef, KProperty property, int value) {
        this.set(value);
    }

    public Animation<RMValueInt> animate(int from, int to, float duration, Easing easing) {
        return this.animate(from, to, duration, easing, 0.0f);
    }

    public Animation<RMValueInt> animate(int from, int to, float duration) {
        return this.animate(from, to, duration, Easing.linear, 0.0f);
    }

    public Animation<RMValueInt> animate(int from, int to, float duration, Easing easing, float delay) {
        AnimationImpl animation = new AnimationImpl(from, to, this);
        animation.setDuration(duration);
        animation.easing = easing;
        animation.setStart(delay);
        Animator.global.add(animation);
        return animation;
    }

    public Animation<RMValueInt> animate(int to, float duration) {
        return this.animate(to, duration, Easing.linear, 0.0f);
    }

    public Animation<RMValueInt> animate(int to, float duration, Easing easing) {
        return this.animate(to, duration, easing, 0.0f);
    }

    public Animation<RMValueInt> animate(int to, float duration, Easing easing, float delay) {
        AnimationImpl anim2 = (AnimationImpl)this.animate(this.get(), to, duration, easing, delay);
        anim2.implicitStart = true;
        return anim2;
    }

    public KeyframeAnimationBuilder animateKeyframes(int initialValue) {
        return this.animateKeyframes(initialValue, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(int initialValue, float delay) {
        return new KeyframeAnimationBuilder(initialValue, delay, this);
    }

    private static class KeyframeAnimation
    extends Animation<RMValueInt> {
        private List<Keyframe> keyframes;

        KeyframeAnimation(RMValueInt target, List<Keyframe> keyframes) {
            super(target, new NullAnimatable());
            this.keyframes = keyframes;
        }

        @Override
        public void update(float time) {
            float progress2 = this.timeFraction(time);
            Keyframe prev = null;
            Keyframe next = null;
            for (Keyframe it : this.keyframes) {
                if (it.time <= progress2) {
                    prev = it;
                }
                if (!(it.time >= progress2) || next != null) continue;
                next = it;
            }
            if (prev != null && next != null) {
                if (next.time == prev.time) {
                    ((RMValueInt)this.getTarget()).set(next.value);
                } else {
                    float partialProgress = next.easing.invoke((progress2 - prev.time) / (next.time - prev.time));
                    ((RMValueInt)this.getTarget()).set((int)((float)prev.value + (float)(next.value - prev.value) * partialProgress));
                }
            } else if (next != null) {
                ((RMValueInt)this.getTarget()).set(next.value);
            } else if (prev != null) {
                ((RMValueInt)this.getTarget()).set(prev.value);
            }
        }
    }

    private static class Keyframe {
        float time;
        int value;
        Easing easing;

        Keyframe(float time, int value, Easing easing) {
            this.time = time;
            this.value = value;
            this.easing = easing;
        }
    }

    public static class KeyframeAnimationBuilder {
        private float delay;
        private RMValueInt target;
        private List<Keyframe> keyframes = new ArrayList<Keyframe>();

        KeyframeAnimationBuilder(int initialValue, float delay, RMValueInt target) {
            this.target = target;
            this.delay = delay;
            this.keyframes.add(new Keyframe(0.0f, initialValue, Easing.linear));
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, int value) {
            return this.add(time, value, Easing.linear);
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, int value, @NotNull Easing easing) {
            this.keyframes.add(new Keyframe(time, value, easing));
            return this;
        }

        @NotNull
        public Animation<RMValueInt> finish() {
            if (this.keyframes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty keyframe animation");
            }
            float duration = 0.0f;
            for (Keyframe keyframe : this.keyframes) {
                duration += keyframe.time;
            }
            float total = 0.0f;
            for (Keyframe it : this.keyframes) {
                it.time = (total += it.time) / duration;
            }
            KeyframeAnimation keyframeAnimation = new KeyframeAnimation(this.target, this.keyframes);
            keyframeAnimation.setDuration(duration);
            keyframeAnimation.setStart(this.delay);
            Animator.global.add(keyframeAnimation);
            return keyframeAnimation;
        }
    }

    private class AnimationImpl
    extends Animation<RMValueInt> {
        int from;
        int to;
        boolean implicitStart;
        Easing easing;

        AnimationImpl(int from, int to, RMValueInt target) {
            super(target, new NullAnimatable());
            this.easing = Easing.linear;
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(float time) {
            if (this.implicitStart) {
                this.from = ((RMValueInt)this.getTarget()).get();
                this.implicitStart = false;
            }
            float progress2 = this.easing.invoke(this.timeFraction(time));
            int newValue = (int)((float)this.from + (float)(this.to - this.from) * progress2);
            ((RMValueInt)this.getTarget()).set(newValue);
        }
    }

    private class Animatable
    implements GuiAnimatable<Animatable> {
        private Animatable() {
        }

        @Override
        @Nullable
        public Object getAnimatableValue() {
            return RMValueInt.this.get();
        }

        @Override
        public void setAnimatableValue(@Nullable Object value) {
            RMValueInt.this.set((Integer)value);
        }

        @Override
        @Nullable
        public Object getAnimatableCallback() {
            return null;
        }

        @Override
        public void setAnimatableCallback(@NotNull Object supplier) {
        }
    }
}

