/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharComparator;

public final class CharHeaps {
    private CharHeaps() {
    }

    public static int downHeap(char[] heap, int size2, int i, CharComparator c) {
        assert (i < size2);
        char e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                char t = heap[child];
                int right = child + 1;
                if (right < size2 && heap[right] < t) {
                    child = right;
                    t = heap[child];
                }
                if (e > t) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                char t = heap[child];
                int right = child + 1;
                if (right < size2 && c.compare(heap[right], t) < 0) {
                    child = right;
                    t = heap[child];
                }
                if (c.compare(e, t) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(char[] heap, int size2, int i, CharComparator c) {
        assert (i < size2);
        char e = heap[i];
        if (c == null) {
            int parent2;
            char t;
            while (i != 0 && (t = heap[parent2 = i - 1 >>> 1]) > e) {
                heap[i] = t;
                i = parent2;
            }
        } else {
            int parent3;
            char t;
            while (i != 0 && c.compare(t = heap[parent3 = i - 1 >>> 1], e) > 0) {
                heap[i] = t;
                i = parent3;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(char[] heap, int size2, CharComparator c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            CharHeaps.downHeap(heap, size2, i, c);
        }
    }
}

