/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.io.Serializable;
import java.util.Collection;
import org.magicwerk.brownies.collections.CollectionAsSet;
import org.magicwerk.brownies.collections.KeyCollectionImpl;
import org.magicwerk.brownies.collections.exceptions.DuplicateKeyException;

public class KeyCollectionAsSet<E>
extends CollectionAsSet<E>
implements Serializable {
    public KeyCollectionAsSet(KeyCollectionImpl<E> coll, boolean immutable) {
        super(coll, immutable);
        coll.checkAsSet();
    }

    @Override
    public boolean add(E e) {
        this.checkMutable();
        try {
            return this.coll.add(e);
        }
        catch (DuplicateKeyException ex) {
            return false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkMutable();
        boolean changed = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }
}

