/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei.energy;

import com.google.common.collect.Lists;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.material.material.Material;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;

public class EnergyIngredientRenderer
implements IIngredientRenderer<EnergyIngredient> {
    @Nonnull
    public static final EnergyIngredientRenderer INSTANCE = new EnergyIngredientRenderer();

    public void render(@Nonnull Minecraft minecraft, int xPosition, int yPosition, @Nullable EnergyIngredient ingredient) {
        if (ingredient != null) {
            String energyString = this.asString(ingredient);
            if (ingredient.hasAmount()) {
                minecraft.field_71466_p.func_175065_a(energyString, (float)(xPosition + 1), (float)(yPosition + 1), 0x808080, false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderHelper.func_74520_c();
                minecraft.func_175599_af().func_184391_a(null, Material.POWDER_INFINITY.getStack(), xPosition, yPosition);
                GlStateManager.func_179084_k();
                RenderHelper.func_74518_a();
                GlStateManager.func_179097_i();
                minecraft.field_71466_p.func_175065_a(energyString, (float)(xPosition + 5), (float)(yPosition + 5), 0xFFFFFF, false);
                GlStateManager.func_179126_j();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Nonnull
    public String asString(@Nonnull EnergyIngredient ingredient) {
        return !ingredient.hasAmount() ? LangPower.RF() : (ingredient.isPerTick() ? LangPower.RFt(ingredient.getAmount()) : LangPower.RF(ingredient.getAmount()));
    }

    @Nonnull
    public List<String> getTooltip(@Nonnull Minecraft minecraft, @Nonnull EnergyIngredient ingredient, @Nonnull ITooltipFlag tooltipFlag) {
        return Lists.newArrayList((Object[])new String[]{Lang.POWER_NAME.get(this.asString(ingredient)), TextFormatting.GRAY + Lang.POWER_DETAILS.get()});
    }

    @Nonnull
    public FontRenderer getFontRenderer(@Nonnull Minecraft minecraft, @Nonnull EnergyIngredient ingredient) {
        return minecraft.field_71466_p;
    }
}

