/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.ConduitTank;
import crazypants.enderio.conduits.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.LiquidOutput;
import crazypants.enderio.conduits.config.ConduitConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AdvancedLiquidConduitNetwork
extends AbstractTankConduitNetwork<AdvancedLiquidConduit> {
    private final ConduitTank tank = new ConduitTank(0);
    private final Set<LiquidOutput> outputs = new HashSet<LiquidOutput>();
    private Iterator<LiquidOutput> outputIterator;
    private boolean lastSyncedActive = false;
    private int lastSyncedVolume = -1;
    private int ticksEmpty;

    public AdvancedLiquidConduitNetwork() {
        super(AdvancedLiquidConduit.class);
    }

    @Override
    public void addConduit(@Nonnull AdvancedLiquidConduit con) {
        this.tank.setCapacity(this.tank.getCapacity() + 1000);
        if (con.getTank().containsValidLiquid()) {
            this.tank.addAmount(con.getTank().getFluidAmount());
        }
        for (EnumFacing dir : con.getExternalConnections()) {
            if (!con.getConnectionMode(dir).acceptsOutput()) continue;
            this.outputs.add(new LiquidOutput(con.getBundle().getLocation().func_177972_a(dir), dir.func_176734_d()));
        }
        this.outputIterator = null;
        super.addConduit(con);
    }

    @Override
    public boolean setFluidType(FluidStack newType) {
        if (super.setFluidType(newType)) {
            FluidStack ft = this.getFluidType();
            this.tank.setLiquid(ft == null ? null : ft.copy());
            return true;
        }
        return false;
    }

    @Override
    public void setFluidTypeLocked(boolean fluidTypeLocked) {
        super.setFluidTypeLocked(fluidTypeLocked);
        if (!fluidTypeLocked && this.tank.isEmpty()) {
            this.setFluidType(null);
        }
    }

    @Override
    public void destroyNetwork() {
        this.setConduitVolumes();
        this.outputs.clear();
        super.destroyNetwork();
    }

    private void setConduitVolumes() {
        if (this.tank.containsValidLiquid() && !this.getConduits().isEmpty()) {
            FluidStack fluidPerConduit = this.tank.getFluid().copy();
            int numCons = this.getConduits().size();
            int leftOvers = fluidPerConduit.amount % numCons;
            fluidPerConduit.amount /= numCons;
            for (AdvancedLiquidConduit con : this.getConduits()) {
                FluidStack f = fluidPerConduit.copy();
                if (leftOvers > 0) {
                    ++f.amount;
                    --leftOvers;
                }
                con.getTank().setLiquid(f);
                BlockPos pos = con.getBundle().getLocation();
                con.getBundle().getEntity().func_145831_w().func_175646_b(pos, con.getBundle().getEntity());
            }
        }
    }

    @Override
    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        if (this.liquidType == null || this.outputs.isEmpty() || !this.tank.containsValidLiquid() || this.tank.isEmpty()) {
            Prof.start(profiler, "updateActiveState");
            this.updateActiveState();
            Prof.stop(profiler);
            return;
        }
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            this.outputIterator = this.outputs.iterator();
        }
        Prof.start(profiler, "updateActiveState");
        this.updateActiveState();
        Prof.next(profiler, "pushFluid");
        for (int numVisited = 0; !this.tank.isEmpty() && numVisited < this.outputs.size(); ++numVisited) {
            LiquidOutput output;
            if (!this.outputIterator.hasNext()) {
                this.outputIterator = this.outputs.iterator();
            }
            if ((output = this.outputIterator.next()) == null) continue;
            Prof.start(profiler, "otherMod_getTankContainer");
            IFluidWrapper cont = this.getTankContainer(output);
            Prof.stop(profiler);
            if (cont == null) continue;
            FluidStack offer = this.tank.getFluid().copy();
            Prof.start(profiler, "otherMod_fill");
            int filled = cont.fill(offer);
            Prof.stop(profiler);
            if (filled <= 0) continue;
            this.tank.addAmount(-filled);
        }
        Prof.stop(profiler);
    }

    private void updateActiveState() {
        boolean isActive;
        boolean bl = isActive = this.tank.containsValidLiquid() && !this.tank.isEmpty();
        if (!isActive) {
            if (!this.fluidTypeLocked && this.liquidType != null) {
                ++this.ticksEmpty;
                if (this.ticksEmpty > 40) {
                    this.setFluidType(null);
                    this.ticksEmpty = 0;
                    for (IServerConduit con : this.getConduits()) {
                        con.setActive(false);
                    }
                    this.lastSyncedActive = false;
                }
            }
            return;
        }
        this.ticksEmpty = 0;
        if (!this.lastSyncedActive) {
            for (IServerConduit con : this.getConduits()) {
                con.setActive(true);
            }
            this.lastSyncedActive = true;
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource.amount = Math.min(resource.amount, (Integer)ConduitConfig.fluid_tier2_maxIO.get());
        boolean liquidWasValid = !this.tank.containsValidLiquid();
        int res = this.tank.fill(resource, doFill);
        if (doFill && res > 0 && !liquidWasValid) {
            int vol = this.tank.getFluidAmount();
            this.setFluidType(resource);
            this.tank.setAmount(vol);
        }
        return res;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.tank.isEmpty() || !this.tank.containsValidLiquid() || !LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), resource)) {
            return null;
        }
        int amount = Math.min(resource.amount, this.tank.getFluidAmount());
        amount = Math.min(amount, (Integer)ConduitConfig.fluid_tier2_maxIO.get());
        FluidStack result = resource.copy();
        result.amount = amount;
        if (doDrain) {
            this.tank.addAmount(-amount);
        }
        return result;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tank.isEmpty() || !this.tank.containsValidLiquid()) {
            return null;
        }
        int amount = Math.min(maxDrain, this.tank.getFluidAmount());
        FluidStack result = this.tank.getFluid().copy();
        result.amount = amount;
        if (doDrain) {
            this.tank.addAmount(-amount);
        }
        return result;
    }

    public boolean extractFrom(@Nonnull AdvancedLiquidConduit advancedLiquidConduit, @Nonnull EnumFacing dir, int maxExtractPerTick) {
        if (this.tank.isFull()) {
            return false;
        }
        IFluidWrapper extTank = this.getTankContainer(advancedLiquidConduit, dir);
        if (extTank != null) {
            int maxExtract = Math.min(maxExtractPerTick, this.tank.getAvailableSpace());
            if (this.liquidType == null || !this.tank.containsValidLiquid()) {
                FluidStack available = extTank.getAvailableFluid();
                if (available == null || available.amount <= 0) {
                    return false;
                }
                this.setFluidType(available);
            }
            FluidStack couldDrain = this.liquidType.copy();
            couldDrain.amount = maxExtract;
            FluidStack drained = extTank.drain(couldDrain);
            if (drained == null || drained.amount == 0) {
                return false;
            }
            if (drained.isFluidEqual(this.getFluidType())) {
                this.tank.addAmount(drained.amount);
            } else {
                extTank.fill(drained);
            }
            return true;
        }
        return false;
    }

    public IFluidWrapper getTankContainer(LiquidOutput output) {
        return FluidWrapper.wrap((IBlockAccess)this.getWorld(), (BlockPos)output.location, (EnumFacing)output.dir);
    }

    public IFluidWrapper getTankContainer(@Nonnull AdvancedLiquidConduit con, @Nonnull EnumFacing dir) {
        return FluidWrapper.wrap((IBlockAccess)this.getWorld(), (BlockPos)con.getBundle().getLocation().func_177972_a(dir), (EnumFacing)dir.func_176734_d());
    }

    World getWorld() {
        if (this.getConduits().isEmpty()) {
            return null;
        }
        return ((AdvancedLiquidConduit)this.getConduits().get(0)).getBundle().getBundleworld();
    }

    public void removeInput(LiquidOutput lo) {
        this.outputs.remove(lo);
        this.outputIterator = null;
    }

    public void addInput(LiquidOutput lo) {
        this.outputs.add(lo);
        this.outputIterator = null;
    }

    public void updateConduitVolumes() {
        if (this.tank.getFluidAmount() == this.lastSyncedVolume) {
            return;
        }
        this.setConduitVolumes();
        this.lastSyncedVolume = this.tank.getFluidAmount();
    }
}

