/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;

public class EnergyContainerHandler
extends MTETrait
implements IEnergyContainer {
    private final long maxCapacity;
    private long energyStored;
    private final long maxInputVoltage;
    private final long maxInputAmperage;
    private final long maxOutputVoltage;
    private final long maxOutputAmperage;
    private Predicate<EnumFacing> sideInputCondition;
    private Predicate<EnumFacing> sideOutputCondition;

    public EnergyContainerHandler(MetaTileEntity tileEntity, long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        super(tileEntity);
        this.maxCapacity = maxCapacity;
        this.maxInputVoltage = maxInputVoltage;
        this.maxInputAmperage = maxInputAmperage;
        this.maxOutputVoltage = maxOutputVoltage;
        this.maxOutputAmperage = maxOutputAmperage;
    }

    public void setSideInputCondition(Predicate<EnumFacing> sideInputCondition) {
        this.sideInputCondition = sideInputCondition;
    }

    public void setSideOutputCondition(Predicate<EnumFacing> sideOutputCondition) {
        this.sideOutputCondition = sideOutputCondition;
    }

    public static EnergyContainerHandler emitterContainer(MetaTileEntity tileEntity, long maxCapacity, long maxOutputVoltage, long maxOutputAmperage) {
        return new EnergyContainerHandler(tileEntity, maxCapacity, 0L, 0L, maxOutputVoltage, maxOutputAmperage);
    }

    public static EnergyContainerHandler receiverContainer(MetaTileEntity tileEntity, long maxCapacity, long maxInputVoltage, long maxInputAmperage) {
        return new EnergyContainerHandler(tileEntity, maxCapacity, maxInputVoltage, maxInputAmperage, 0L, 0L);
    }

    @Override
    public String getName() {
        return "EnergyContainer";
    }

    @Override
    public int getNetworkID() {
        return 1;
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this);
        }
        return null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("EnergyStored", this.energyStored);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        this.energyStored = compound.func_74763_f("EnergyStored");
        this.notifyEnergyListener(true);
    }

    @Override
    public long getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(long energyStored) {
        this.energyStored = energyStored;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.notifyEnergyListener(false);
        }
    }

    protected void notifyEnergyListener(boolean isInitialChange) {
        if (this.metaTileEntity instanceof IEnergyChangeListener) {
            ((IEnergyChangeListener)((Object)this.metaTileEntity)).onEnergyChanged(this, isInitialChange);
        }
    }

    public boolean dischargeOrRechargeEnergyContainers(IItemHandlerModifiable itemHandler, int slotIndex) {
        ItemStack stackInSlot = itemHandler.getStackInSlot(slotIndex);
        if (stackInSlot.func_190926_b()) {
            return false;
        }
        IElectricItem electricItem = (IElectricItem)stackInSlot.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null || !electricItem.canProvideChargeExternally()) {
            return false;
        }
        byte machineTier = GTUtility.getTierByVoltage(Math.max(this.getInputVoltage(), this.getOutputVoltage()));
        if (this.getEnergyCanBeInserted() > 0L) {
            double chargePercent = (double)this.getEnergyStored() / ((double)this.getEnergyCapacity() * 1.0);
            if (chargePercent <= 0.5) {
                long dischargedBy = electricItem.discharge(this.getEnergyCanBeInserted(), machineTier, false, true, false);
                this.addEnergy(dischargedBy);
                return dischargedBy > 0L;
            }
            if (chargePercent >= 0.9) {
                long chargedBy = electricItem.charge(this.getEnergyStored(), machineTier, false, false);
                this.removeEnergy(chargedBy);
                return chargedBy > 0L;
            }
        }
        return false;
    }

    @Override
    public void update() {
        if (this.getMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (this.getEnergyStored() >= this.getOutputVoltage() && this.getOutputVoltage() > 0L && this.getOutputAmperage() > 0L) {
            long outputVoltage = this.getOutputVoltage();
            long outputAmperes = Math.min(this.getEnergyStored() / outputVoltage, this.getOutputAmperage());
            if (outputAmperes == 0L) {
                return;
            }
            long amperesUsed = 0L;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IEnergyContainer energyContainer;
                if (!this.outputsEnergy(side)) continue;
                TileEntity tileEntity = this.metaTileEntity.getWorld().func_175625_s(this.metaTileEntity.getPos().func_177972_a(side));
                EnumFacing oppositeSide = side.func_176734_d();
                if (tileEntity != null && tileEntity.hasCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide) && (energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide)) != null && energyContainer.inputsEnergy(oppositeSide) && (amperesUsed += energyContainer.acceptEnergyFromNetwork(oppositeSide, outputVoltage, outputAmperes - amperesUsed)) == outputAmperes) break;
            }
            if (amperesUsed > 0L) {
                this.setEnergyStored(this.getEnergyStored() - amperesUsed * outputVoltage);
            }
        }
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
        if (voltage > 0L && amperage > 0L && (side == null || this.inputsEnergy(side))) {
            long amperesAccepted;
            if (voltage > this.getInputVoltage()) {
                GTUtility.doOvervoltageExplosion(this.metaTileEntity, voltage);
                return Math.min(amperage, this.getInputAmperage());
            }
            if (canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage()))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                return amperesAccepted;
            }
        }
        return 0L;
    }

    @Override
    public long getEnergyCapacity() {
        return this.maxCapacity;
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return !this.outputsEnergy(side) && this.getInputVoltage() > 0L && (this.sideInputCondition == null || this.sideInputCondition.test(side));
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return this.getOutputVoltage() > 0L && (this.sideOutputCondition == null || this.sideOutputCondition.test(side));
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long newEnergyStored;
        long oldEnergyStored = this.getEnergyStored();
        long l = newEnergyStored = this.maxCapacity - oldEnergyStored < energyToAdd ? this.maxCapacity : oldEnergyStored + energyToAdd;
        if (newEnergyStored < 0L) {
            newEnergyStored = 0L;
        }
        this.setEnergyStored(newEnergyStored);
        return newEnergyStored - oldEnergyStored;
    }

    @Override
    public long getOutputVoltage() {
        return this.maxOutputVoltage;
    }

    @Override
    public long getOutputAmperage() {
        return this.maxOutputAmperage;
    }

    @Override
    public long getInputAmperage() {
        return this.maxInputAmperage;
    }

    @Override
    public long getInputVoltage() {
        return this.maxInputVoltage;
    }

    public static interface IEnergyChangeListener {
        public void onEnergyChanged(IEnergyContainer var1, boolean var2);
    }
}

