/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.api.recipes.recipes.FuelRecipe;
import gregtech.api.util.GTUtility;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class FuelRecipeLogic
extends MTETrait
implements IControllable {
    public final FuelRecipeMap recipeMap;
    protected FuelRecipe previousRecipe;
    protected final Supplier<IEnergyContainer> energyContainer;
    protected final Supplier<IMultipleTankHandler> fluidTank;
    public final long maxVoltage;
    private int recipeDurationLeft;
    private long recipeOutputVoltage;
    private boolean isActive;
    private boolean workingEnabled = true;
    private boolean wasActiveAndNeedsUpdate = false;

    public FuelRecipeLogic(MetaTileEntity metaTileEntity, FuelRecipeMap recipeMap, Supplier<IEnergyContainer> energyContainer, Supplier<IMultipleTankHandler> fluidTank, long maxVoltage) {
        super(metaTileEntity);
        this.recipeMap = recipeMap;
        this.energyContainer = energyContainer;
        this.fluidTank = fluidTank;
        this.maxVoltage = maxVoltage;
    }

    public long getRecipeOutputVoltage() {
        return this.recipeOutputVoltage;
    }

    @Override
    public String getName() {
        return "FuelRecipeMapWorkable";
    }

    @Override
    public int getNetworkID() {
        return 2;
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return null;
    }

    @Override
    public void update() {
        if (this.getMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (this.workingEnabled) {
            if (this.recipeDurationLeft > 0 && (this.energyContainer.get().getEnergyCanBeInserted() >= this.recipeOutputVoltage || this.shouldVoidExcessiveEnergy())) {
                this.energyContainer.get().addEnergy(this.recipeOutputVoltage);
                if (--this.recipeDurationLeft == 0) {
                    this.wasActiveAndNeedsUpdate = true;
                }
            }
            if (this.recipeDurationLeft == 0) {
                this.tryAcquireNewRecipe();
            }
        }
        if (this.wasActiveAndNeedsUpdate) {
            this.setActive(false);
            this.wasActiveAndNeedsUpdate = false;
        }
    }

    protected boolean shouldVoidExcessiveEnergy() {
        return false;
    }

    private void tryAcquireNewRecipe() {
        IMultipleTankHandler fluidTanks = this.fluidTank.get();
        for (IFluidTank fluidTank : fluidTanks) {
            int fuelAmountUsed;
            FluidStack tankContents = fluidTank.getFluid();
            if (tankContents == null || tankContents.amount <= 0 || (fuelAmountUsed = this.tryAcquireNewRecipe(tankContents)) <= 0) continue;
            fluidTank.drain(fuelAmountUsed, true);
            break;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private int tryAcquireNewRecipe(FluidStack fluidStack) {
        int fuelAmountToUse;
        FuelRecipe currentRecipe;
        if (this.previousRecipe != null && this.previousRecipe.matches(this.getMaxVoltage(), fluidStack)) {
            currentRecipe = this.previousRecipe;
        } else {
            currentRecipe = this.recipeMap.findRecipe(this.getMaxVoltage(), fluidStack);
            if (currentRecipe != null) {
                this.previousRecipe = currentRecipe;
            }
        }
        if (currentRecipe != null && this.checkRecipe(currentRecipe) && fluidStack.amount >= (fuelAmountToUse = this.calculateFuelAmount(currentRecipe))) {
            this.recipeDurationLeft = this.calculateRecipeDuration(currentRecipe);
            this.recipeOutputVoltage = this.startRecipe(currentRecipe, fuelAmountToUse, this.recipeDurationLeft);
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
            } else {
                this.setActive(true);
            }
            return fuelAmountToUse;
        }
        return 0;
    }

    protected boolean checkRecipe(FuelRecipe recipe) {
        return true;
    }

    public long getMaxVoltage() {
        return this.maxVoltage;
    }

    protected int calculateFuelAmount(FuelRecipe currentRecipe) {
        return currentRecipe.getRecipeFluid().amount * FuelRecipeLogic.getVoltageMultiplier(this.getMaxVoltage(), currentRecipe.getMinVoltage());
    }

    protected int calculateRecipeDuration(FuelRecipe currentRecipe) {
        return currentRecipe.getDuration();
    }

    protected long startRecipe(FuelRecipe currentRecipe, int fuelAmountUsed, int recipeDuration) {
        return this.getMaxVoltage();
    }

    public static int getVoltageMultiplier(long maxVoltage, long minVoltage) {
        return (int)(maxVoltage / minVoltage);
    }

    public static long getTieredVoltage(long voltage) {
        return GTValues.V[GTUtility.getTierByVoltage(voltage)];
    }

    private void setActive(boolean active) {
        this.isActive = active;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(1, buf -> buf.writeBoolean(active));
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        this.metaTileEntity.markDirty();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 1) {
            this.isActive = buf.readBoolean();
            this.getMetaTileEntity().getHolder().scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buf) {
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialData(PacketBuffer buf) {
        this.isActive = buf.readBoolean();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("WorkEnabled", this.workingEnabled);
        compound.func_74768_a("RecipeDurationLeft", this.recipeDurationLeft);
        if (this.recipeDurationLeft > 0) {
            compound.func_74772_a("RecipeOutputVoltage", this.recipeOutputVoltage);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        if (!compound.func_150297_b("WorkEnabled", 1)) {
            this.workingEnabled = compound.func_74767_n("WorkEnabled");
        }
        this.recipeDurationLeft = compound.func_74762_e("RecipeDurationLeft");
        if (this.recipeDurationLeft > 0) {
            this.recipeOutputVoltage = compound.func_74763_f("RecipeOutputVoltage");
        }
        this.isActive = this.recipeDurationLeft > 0;
    }
}

