/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.UIFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class CoverBehaviorUIFactory
extends UIFactory<CoverBehavior> {
    public static final CoverBehaviorUIFactory INSTANCE = new CoverBehaviorUIFactory();

    private CoverBehaviorUIFactory() {
    }

    public void init() {
        UIFactory.FACTORY_REGISTRY.register(2, new ResourceLocation("gregtech", "cover_behavior_factory"), this);
    }

    @Override
    protected ModularUI createUITemplate(CoverBehavior holder, EntityPlayer entityPlayer) {
        return ((CoverWithUI)((Object)holder)).createUI(entityPlayer);
    }

    @Override
    protected CoverBehavior readHolderFromSyncData(PacketBuffer syncData) {
        ICoverable coverable;
        BlockPos blockPos = syncData.func_179259_c();
        EnumFacing attachedSide = EnumFacing.field_82609_l[syncData.readByte()];
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(blockPos);
        ICoverable iCoverable = coverable = tileEntity == null ? null : (ICoverable)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_COVERABLE, null);
        if (coverable != null) {
            return coverable.getCoverAtSide(attachedSide);
        }
        return null;
    }

    @Override
    protected void writeHolderToSyncData(PacketBuffer syncData, CoverBehavior holder) {
        syncData.func_179255_a(holder.coverHolder.getPos());
        syncData.writeByte(holder.attachedSide.ordinal());
    }
}

