/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.ISizeProvider;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.WidgetUIAccess;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Widget {
    protected ModularUI gui;
    protected ISizeProvider sizes;
    protected WidgetUIAccess uiAccess;

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public void setSizes(ISizeProvider sizes) {
        this.sizes = sizes;
    }

    public void setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
    }

    public static boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && x + width >= mouseX && y + height >= mouseY;
    }

    public void initWidget() {
    }

    public void detectAndSendChanges() {
    }

    public void updateScreen() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyTyped(char charTyped, int keyCode) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
    }

    public void handleClientAction(int id, PacketBuffer buffer) {
    }

    public List<INativeWidget> getNativeWidgets() {
        if (this instanceof INativeWidget) {
            return Collections.singletonList((INativeWidget)((Object)this));
        }
        return Collections.emptyList();
    }

    protected final void writeUpdateInfo(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected final void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null) {
            this.uiAccess.writeClientAction(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawHoveringText(ItemStack itemStack, List<String> tooltip, int maxTextWidth, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText((ItemStack)itemStack, tooltip, (int)mouseX, (int)mouseY, (int)(this.sizes.getScreenWidth() - this.sizes.getGuiLeft()), (int)(this.sizes.getScreenHeight() - this.sizes.getGuiTop()), (int)maxTextWidth, (FontRenderer)mc.field_71466_p);
    }

    @SideOnly(value=Side.CLIENT)
    protected void playButtonClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

