/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.base.Preconditions;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AbstractPositionedRectangleWidget;
import gregtech.api.util.function.BooleanConsumer;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToggleButtonWidget
extends AbstractPositionedRectangleWidget {
    protected TextureArea buttonTexture;
    private BooleanSupplier isPressedCondition;
    private BooleanConsumer setPressedExecutor;
    private String tooltipText;
    protected boolean isPressed;

    public ToggleButtonWidget(int xPosition, int yPosition, int width, int height, BooleanSupplier isPressedCondition, BooleanConsumer setPressedExecutor) {
        this(xPosition, yPosition, width, height, GuiTextures.VANILLA_BUTTON, isPressedCondition, setPressedExecutor);
    }

    public ToggleButtonWidget(int xPosition, int yPosition, int width, int height, TextureArea buttonTexture, BooleanSupplier isPressedCondition, BooleanConsumer setPressedExecutor) {
        super(xPosition, yPosition, width, height);
        Preconditions.checkNotNull((Object)buttonTexture, (Object)"texture");
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.buttonTexture = buttonTexture;
        this.isPressedCondition = isPressedCondition;
        this.setPressedExecutor = setPressedExecutor;
    }

    public ToggleButtonWidget setButtonTexture(TextureArea texture) {
        Preconditions.checkNotNull((Object)texture, (Object)"texture");
        this.buttonTexture = texture;
        return this;
    }

    public ToggleButtonWidget setTooltipText(String tooltipText) {
        Preconditions.checkNotNull((Object)tooltipText, (Object)"tooltipText");
        this.tooltipText = tooltipText;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY) {
        if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(this.xPosition, this.yPosition, this.width, this.height, this.isPressed ? 0.5 : 0.0, 0.5);
        } else {
            this.buttonTexture.drawSubArea(this.xPosition, this.yPosition, this.width, this.height, 0.0, this.isPressed ? 0.5 : 0.0, 1.0, 0.5);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY) && this.tooltipText != null) {
            String postfix = this.isPressed ? ".enabled" : ".disabled";
            String tooltipHoverString = this.tooltipText + postfix;
            List<String> hoverList = Arrays.asList(I18n.func_135052_a((String)tooltipHoverString, (Object[])new Object[0]).split("/n"));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.isPressedCondition.getAsBoolean() != this.isPressed) {
            this.isPressed = this.isPressedCondition.getAsBoolean();
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(this.isPressed));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.isPressed = buffer.readBoolean();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (ToggleButtonWidget.isMouseOver(this.xPosition, this.yPosition, this.width, this.height, mouseX, mouseY)) {
            this.isPressed = !this.isPressed;
            this.writeClientAction(1, buf -> buf.writeBoolean(this.isPressed));
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            this.isPressed = buffer.readBoolean();
            this.setPressedExecutor.apply(this.isPressed);
        }
    }
}

