/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.raytracer.RayTracer;
import gregtech.api.items.toolitem.IAOEItem;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ToolRenderHandler
implements IResourceManagerReloadListener {
    public static final ToolRenderHandler INSTANCE = new ToolRenderHandler();
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];

    private ToolRenderHandler() {
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        RayTraceResult rayTraceResult;
        ItemStack itemStack;
        Minecraft mc = Minecraft.func_71410_x();
        Iterator iterator = event.getContext().field_72738_E.keySet().iterator();
        while (iterator.hasNext()) {
            DestroyBlockProgress progress;
            RayTraceResult rayTraceResult2;
            EntityPlayer entityPlayer;
            ItemStack itemStack2;
            int breakerEntityId = (Integer)iterator.next();
            Entity breakerEntity = mc.field_71441_e.func_73045_a(breakerEntityId);
            if (!(breakerEntity instanceof EntityPlayer) || !((itemStack2 = (entityPlayer = (EntityPlayer)breakerEntity).func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof IAOEItem) || (rayTraceResult2 = RayTracer.retraceBlock((World)mc.field_71441_e, (EntityPlayer)entityPlayer, (BlockPos)(progress = (DestroyBlockProgress)event.getContext().field_72738_E.get(breakerEntityId)).func_180246_b())) == null || rayTraceResult2.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            List<BlockPos> aoeBlocksToRender = ((IAOEItem)itemStack2.func_77973_b()).getAOEBlocks(itemStack2, entityPlayer, rayTraceResult2);
            int breakProgress = progress.func_73106_e();
            this.preRenderDamagedBlocks();
            this.drawBlockDamageTexture(mc, Tessellator.func_178181_a(), mc.func_175606_aa(), event.getPartialTicks(), aoeBlocksToRender, breakProgress);
            this.postRenderDamagedBlocks();
        }
        PlayerControllerMP playerController = mc.field_71442_b;
        if (!playerController.func_181040_m() && (itemStack = mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof IAOEItem && (rayTraceResult = RayTracer.retrace((EntityPlayer)mc.field_71439_g)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            List<BlockPos> aoeBlocksToRender = ((IAOEItem)itemStack.func_77973_b()).getAOEBlocks(itemStack, (EntityPlayer)mc.field_71439_g, rayTraceResult);
            this.preRenderSelectionOutline();
            this.drawSelectionOutlines(mc, aoeBlocksToRender, mc.func_175606_aa(), event.getPartialTicks());
            this.postRenderSelectionOutline();
        }
    }

    private void preRenderSelectionOutline() {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
    }

    private void postRenderSelectionOutline() {
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public void drawSelectionOutlines(Minecraft mc, List<BlockPos> blocksToRender, Entity entityIn, float partialTicks) {
        double d3 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d4 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d5 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        for (BlockPos blockPos : blocksToRender) {
            IBlockState blockState = mc.field_71441_e.func_180495_p(blockPos);
            AxisAlignedBB box = blockState.func_185918_c((World)mc.field_71441_e, blockPos).func_186662_g(0.002).func_72317_d(-d3, -d4, -d5);
            RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
    }

    public void drawBlockDamageTexture(Minecraft mc, Tessellator tessellator, Entity viewEntity, float partialTicks, List<BlockPos> blocksToRender, int partialBlockDamage) {
        double d3 = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * (double)partialTicks;
        double d4 = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * (double)partialTicks;
        double d5 = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * (double)partialTicks;
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        BlockRendererDispatcher rendererDispatcher = mc.func_175602_ab();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.preRenderDamagedBlocks();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilder.func_178969_c(-d3, -d4, -d5);
        bufferBuilder.func_78914_f();
        for (BlockPos blockPos : blocksToRender) {
            IBlockState blockState = mc.field_71441_e.func_180495_p(blockPos);
            TileEntity tileEntity = mc.field_71441_e.func_175625_s(blockPos);
            boolean hasBreak = tileEntity != null && tileEntity.canRenderBreaking();
            if (hasBreak || blockState.func_185904_a() == Material.field_151579_a) continue;
            TextureAtlasSprite textureAtlasSprite = this.destroyBlockIcons[partialBlockDamage];
            rendererDispatcher.func_175020_a(blockState, blockPos, textureAtlasSprite, (IBlockAccess)mc.field_71441_e);
        }
        tessellator.func_78381_a();
        bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
        this.postRenderDamagedBlocks();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.updateDestroyBlockIcons();
    }

    private void updateDestroyBlockIcons() {
        Minecraft mc = Minecraft.func_71410_x();
        TextureMap texturemap = mc.func_147117_R();
        for (int i = 0; i < this.destroyBlockIcons.length; ++i) {
            this.destroyBlockIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }
}

