/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.GTUtility;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SoftHammerBehaviour
implements IItemBehaviour {
    private final int cost;

    public SoftHammerBehaviour(int cost) {
        this.cost = cost;
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IControllable controllable;
        if (world.field_72995_K || world.func_175623_d(pos)) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (controllable = (IControllable)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, side)) != null) {
            if (controllable.isWorkingEnabled()) {
                controllable.setWorkingEnabled(false);
            } else {
                controllable.setWorkingEnabled(true);
            }
            GTUtility.doDamageItem(stack, this.cost, false);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"behaviour.soft_hammer", (Object[])new Object[0]));
    }
}

