/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.recipes.ModHandler;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WatchedFluidTank;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityTank
extends MetaTileEntity {
    private final int tankSize;
    private final SolidMaterial material;
    private SyncFluidTank fluidTank;
    private int oldLightValue = 0;

    public MetaTileEntityTank(ResourceLocation metaTileEntityId, SolidMaterial material, int tankSize) {
        super(metaTileEntityId);
        this.tankSize = tankSize;
        this.material = material;
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityTank(this.metaTileEntityId, this.material, this.tankSize);
    }

    @Override
    public int getLightValue() {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack == null) {
            return 0;
        }
        return fluidStack.getFluid().getLuminosity(fluidStack);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public String getHarvestTool() {
        return ModHandler.isMaterialWood(this.material) ? "axe" : "pickaxe";
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.fluidTank = new SyncFluidTank(this.tankSize);
        this.fluidInventory = this.fluidTank;
        this.updateComparatorValue();
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("Fluid"));
            this.fluidTank.setFluid(fluidStack);
            this.fluidTank.onContentsChanged();
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            itemStack.func_74782_a("Fluid", (NBTBase)tagCompound);
        }
    }

    @Override
    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return new FluidHandlerItemStack(itemStack, this.tankSize){

            public boolean canFillFluidType(FluidStack fluid) {
                return MetaTileEntityTank.this.canFillFluidType(fluid);
            }
        };
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        FluidStack fluidStack = this.fluidTank.getFluid();
        buf.writeBoolean(fluidStack != null);
        if (fluidStack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            buf.func_150786_a(tagCompound);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        FluidStack fluidStack = null;
        if (buf.readBoolean()) {
            try {
                NBTTagCompound tagCompound = buf.func_150793_b();
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 200) {
            FluidStack fluidStack = null;
            if (buf.readBoolean()) {
                try {
                    NBTTagCompound tagCompound = buf.func_150793_b();
                    fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
                }
                catch (IOException tagCompound) {
                    // empty catch block
                }
            }
            this.fluidTank.setFluid(fluidStack);
            this.updateLightValue();
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == 201) {
            int newFluidAmount = buf.func_150792_a();
            FluidStack fluidStack = this.fluidTank.getFluid();
            if (fluidStack != null) {
                fluidStack.amount = newFluidAmount;
                this.getHolder().scheduleChunkForRenderUpdate();
                this.updateLightValue();
            }
        }
    }

    private void updateLightValue() {
        int newLightValue = this.getLightValue();
        if (this.oldLightValue != newLightValue) {
            this.oldLightValue = newLightValue;
            this.getWorld().func_175664_x(this.getPos());
        }
    }

    @Override
    public int getActualComparatorValue() {
        SyncFluidTank fluidTank = this.fluidTank;
        int fluidAmount = fluidTank.getFluidAmount();
        int maxCapacity = fluidTank.getCapacity();
        float f = (float)fluidAmount / ((float)maxCapacity * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (fluidAmount > 0 ? 1 : 0);
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.getWorld().field_72995_K || FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)this.fluidTank);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        if (ModHandler.isMaterialWood(this.material)) {
            return Pair.of((Object)Textures.WOODEN_TANK.getParticleTexture(), (Object)this.getPaintingColor());
        }
        return Pair.of((Object)Textures.METAL_TANK.getParticleTexture(), (Object)this.getPaintingColor());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        FluidStack fluidStack = this.getFluidForRendering();
        if (ModHandler.isMaterialWood(this.material)) {
            Textures.WOODEN_TANK.render(renderState, translation, GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()), pipeline, this.tankSize, fluidStack);
        } else {
            int baseColor = ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.material.materialRGB), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
            Textures.METAL_TANK.render(renderState, translation, baseColor, pipeline, this.tankSize, fluidStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private FluidStack getFluidForRendering() {
        if (this.getWorld() == null && this.renderContextStack != null) {
            NBTTagCompound tagCompound = this.renderContextStack.func_77978_p();
            if (tagCompound != null && tagCompound.func_150297_b("Fluid", 10)) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            }
            return null;
        }
        return this.fluidTank.getFluid();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.tankSize}));
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            if (fluidStack == null) {
                return;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_tank.fluid", (Object[])new Object[]{fluidStack.amount, I18n.func_135052_a((String)fluidStack.getUnlocalizedName(), (Object[])new Object[0])}));
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("FluidInventory", (NBTBase)((FluidTank)this.fluidInventory).writeToNBT(new NBTTagCompound()));
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        ((FluidTank)this.fluidInventory).readFromNBT(data.func_74775_l("FluidInventory"));
    }

    protected boolean canFillFluidType(FluidStack fluid) {
        return !ModHandler.isMaterialWood(this.material) && !this.material.hasFlag(Material.MatFlags.FLAMMABLE) || fluid.getFluid().getTemperature(fluid) <= 325;
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    private class SyncFluidTank
    extends WatchedFluidTank {
        public SyncFluidTank(int capacity) {
            super(capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return MetaTileEntityTank.this.canFillFluidType(fluid);
        }

        @Override
        protected void onFluidChanged(FluidStack newFluidStack, FluidStack oldFluidStack) {
            MetaTileEntityTank.this.updateComparatorValue();
            if (MetaTileEntityTank.this.getWorld() != null && !MetaTileEntityTank.this.getWorld().field_72995_K) {
                this.onContentsChangedOnServer(newFluidStack, oldFluidStack);
            }
        }

        private void onContentsChangedOnServer(FluidStack newFluid, FluidStack oldFluidStack) {
            MetaTileEntityTank.this.updateLightValue();
            if (newFluid != null && newFluid.isFluidEqual(oldFluidStack)) {
                MetaTileEntityTank.this.writeCustomData(201, buf -> buf.func_150787_b(newFluid.amount));
            } else {
                MetaTileEntityTank.this.writeCustomData(200, buf -> {
                    buf.writeBoolean(newFluid != null);
                    if (newFluid != null) {
                        NBTTagCompound tagCompound = new NBTTagCompound();
                        newFluid.writeToNBT(tagCompound);
                        buf.func_150786_a(tagCompound);
                    }
                });
            }
        }
    }
}

