/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.multipart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.multipart.FluidPipeActiveMultiPart;
import gregtech.common.multipart.GTMultipartFactory;
import gregtech.common.multipart.PipeMultiPart;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.FluidPipeFluidHandler;
import gregtech.common.render.FluidPipeRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class FluidPipeMultiPart
extends PipeMultiPart<FluidPipeType, FluidPipeProperties> {
    private FluidPipeFluidHandler fluidHandler;

    FluidPipeMultiPart() {
    }

    public FluidPipeMultiPart(IPipeTile<FluidPipeType, FluidPipeProperties> sourceTile) {
        super(sourceTile);
    }

    public ResourceLocation getType() {
        return GTMultipartFactory.FLUID_PIPE_PART_KEY;
    }

    @Override
    protected PipeMultiPart<FluidPipeType, FluidPipeProperties> toTickablePart() {
        return new FluidPipeActiveMultiPart(this);
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    @Override
    protected void onModeChange(boolean isActiveNow) {
        if (!(this instanceof FluidPipeActiveMultiPart) && isActiveNow) {
            FluidPipeActiveMultiPart part = new FluidPipeActiveMultiPart(this);
            part.setActivePart(true);
            this.isBeingReplaced = true;
            part.isBeingReplaced = true;
            TileMultipart tileMultipart = this.tile();
            tileMultipart.remPart((TMultiPart)this);
            TileMultipart.addPart((World)tileMultipart.func_145831_w(), (BlockPos)tileMultipart.func_174877_v(), (TMultiPart)part);
        } else if (this instanceof FluidPipeActiveMultiPart) {
            ((FluidPipeActiveMultiPart)this).setActivePart(isActiveNow);
        }
    }

    public FluidPipeFluidHandler getFluidHandler() {
        if (this.fluidHandler == null) {
            this.fluidHandler = new FluidPipeFluidHandler(this);
        }
        return this.fluidHandler;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidHandler());
        }
        return super.getCapabilityInternal(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, BlockRenderLayer layer, CCRenderState ccrs) {
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT) {
            FluidPipeRenderer.INSTANCE.renderPipeBlock(this.getPipeMaterial(), (FluidPipeType)this.getPipeType(), this.getInsulationColor(), ccrs, new IVertexOperation[]{new Translation(pos)}, this.activeConnections);
            this.getCoverableImplementation().renderCovers(ccrs, new Matrix4().translate(pos));
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return FluidPipeRenderer.INSTANCE.getParticleTexture(this);
    }
}

