/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.RoughSolidMaterial;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import org.apache.commons.lang3.ArrayUtils;

public class ToolRecipeHandler {
    public static MetaItem.MetaValueItem[] motorItems;
    public static SolidMaterial[] baseMaterials;
    public static MetaItem.MetaValueItem[][] batteryItems;
    public static MetaItem.MetaValueItem[] powerUnitItems;

    public static void register() {
        OrePrefix.stick.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processStick);
        OrePrefix.stickLong.addProcessingHandler(IngotMaterial.class, ToolRecipeHandler::processLongStick);
        OrePrefix.toolHeadShovel.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processShovelHead);
        OrePrefix.toolHeadAxe.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processAxeHead);
        OrePrefix.toolHeadPickaxe.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processPickaxeHead);
        OrePrefix.toolHeadSword.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processSwordHead);
        OrePrefix.toolHeadHoe.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processHoeHead);
        OrePrefix.toolHeadSaw.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processSawHead);
        OrePrefix.toolHeadChainsaw.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processChainSawHead);
        OrePrefix.toolHeadDrill.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processDrillHead);
        OrePrefix.toolHeadSense.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processSenseHead);
        OrePrefix.toolHeadWrench.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processWrenchHead);
        OrePrefix.toolHeadBuzzSaw.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processBuzzSawHead);
        OrePrefix.toolHeadFile.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processFileHead);
        OrePrefix.toolHeadUniversalSpade.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processSpadeHead);
        OrePrefix.toolHeadScrewdriver.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processScrewdriverHead);
        OrePrefix.toolHeadHammer.addProcessingHandler(SolidMaterial.class, ToolRecipeHandler::processHammerHead);
    }

    public static void initializeMetaItems() {
        motorItems = new MetaItem.MetaValueItem[]{MetaItems.ELECTRIC_MOTOR_LV, MetaItems.ELECTRIC_MOTOR_MV, MetaItems.ELECTRIC_MOTOR_HV};
        baseMaterials = new SolidMaterial[]{Materials.StainlessSteel, Materials.Titanium, Materials.TungstenSteel};
        powerUnitItems = new MetaItem.MetaValueItem[]{MetaItems.POWER_UNIT_LV, MetaItems.POWER_UNIT_MV, MetaItems.POWER_UNIT_HV};
        batteryItems = new MetaItem.MetaValueItem[][]{{MetaItems.BATTERY_RE_LV_LITHIUM, MetaItems.BATTERY_RE_LV_CADMIUM, MetaItems.BATTERY_RE_LV_SODIUM}, {MetaItems.BATTERY_RE_MV_LITHIUM, MetaItems.BATTERY_RE_MV_CADMIUM, MetaItems.BATTERY_RE_MV_SODIUM}, {MetaItems.BATTERY_RE_HV_LITHIUM, MetaItems.BATTERY_RE_HV_CADMIUM, MetaItems.BATTERY_RE_HV_SODIUM}};
    }

    public static void registerPowerUnitRecipes() {
        for (int i = 0; i < powerUnitItems.length; ++i) {
            MetaItem.MetaValueItem[] metaValueItemArray = batteryItems[i];
            int n = metaValueItemArray.length;
            for (int j = 0; j < n; ++j) {
                MetaItem.MetaValueItem batteryItem = metaValueItemArray[j];
                ItemStack batteryStack = batteryItem.getStackForm();
                long maxCharge = ((IElectricItem)batteryStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)).getMaxCharge();
                ItemStack powerUnitStack = powerUnitItems[i].getMaxChargeOverrideStack(maxCharge);
                String recipeName = String.format("%s_%s", ToolRecipeHandler.powerUnitItems[i].unlocalizedName, batteryItem.unlocalizedName);
                ModHandler.addShapedEnergyTransferRecipe(recipeName, powerUnitStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{batteryStack}), false, "S  ", "GMG", "PBP", Character.valueOf('M'), motorItems[i].getStackForm(), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, baseMaterials[i]), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, baseMaterials[i]), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, baseMaterials[i]), Character.valueOf('B'), batteryStack);
            }
        }
        for (MetaItem.MetaValueItem batteryItem : batteryItems[2]) {
            ItemStack batteryStack = batteryItem.getStackForm();
            long maxCharge = ((IElectricItem)batteryStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)).getMaxCharge();
            ItemStack hammerBaseStack = MetaItems.JACKHAMMER_BASE.getMaxChargeOverrideStack(maxCharge);
            String recipeName = String.format("jackhammer_base_%s", batteryItem.unlocalizedName);
            ModHandler.addShapedEnergyTransferRecipe(recipeName, hammerBaseStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{batteryStack}), false, "S  ", "PRP", "MPB", Character.valueOf('M'), MetaItems.ELECTRIC_PISTON_HV.getStackForm(), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Titanium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plateDense, Materials.Titanium), Character.valueOf('R'), new UnificationEntry(OrePrefix.spring, Materials.Titanium), Character.valueOf('B'), batteryStack);
        }
    }

    public static void processSimpleElectricToolHead(OrePrefix toolPrefix, SolidMaterial solidMaterial, ToolMetaItem.MetaToolValueItem[] toolItems) {
        for (int i = 0; i < toolItems.length; ++i) {
            for (MetaItem.MetaValueItem batteryItem : batteryItems[i]) {
                ItemStack batteryStack = batteryItem.getStackForm();
                long maxCharge = ((IElectricItem)batteryStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)).getMaxCharge();
                ItemStack chargedDrillStack = toolItems[i].getMaxChargeOverrideStack(solidMaterial, maxCharge);
                String recipeNameFirst = String.format("%s_%s_%s_full", toolItems[i].unlocalizedName, solidMaterial, batteryItem.unlocalizedName);
                ModHandler.addShapedEnergyTransferRecipe(recipeNameFirst, chargedDrillStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{batteryStack}), false, "SXd", "GMG", "PBP", Character.valueOf('X'), new UnificationEntry(toolPrefix, solidMaterial), Character.valueOf('M'), motorItems[i].getStackForm(), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, baseMaterials[i]), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, baseMaterials[i]), Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, baseMaterials[i]), Character.valueOf('B'), batteryStack);
            }
            ItemStack drillStack = toolItems[i].getStackForm(solidMaterial);
            ItemStack powerUnitStack = powerUnitItems[i].getStackForm();
            String recipeNameSecond = String.format("%s_%s_unit", toolItems[i].unlocalizedName, solidMaterial);
            ModHandler.addShapedEnergyTransferRecipe(recipeNameSecond, drillStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{powerUnitStack}), true, "wHd", " U ", Character.valueOf('H'), new UnificationEntry(toolPrefix, solidMaterial), Character.valueOf('U'), powerUnitStack);
        }
    }

    public static void processSimpleToolHead(OrePrefix toolPrefix, SolidMaterial solidMaterial, ToolMetaItem.MetaToolValueItem toolItem, Object ... recipe) {
        RoughSolidMaterial handleMaterial = Materials.Wood;
        ModHandler.addShapelessRecipe(String.format("%s_%s_%s", toolPrefix.name(), solidMaterial, handleMaterial), toolItem.getStackForm(solidMaterial), new UnificationEntry(toolPrefix, solidMaterial), new UnificationEntry(OrePrefix.stick, handleMaterial));
        if (solidMaterial instanceof IngotMaterial && solidMaterial.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE)) {
            ToolRecipeHandler.addSimpleToolRecipe(toolPrefix, solidMaterial, toolItem, new UnificationEntry(OrePrefix.plate, solidMaterial), new UnificationEntry(OrePrefix.ingot, solidMaterial), recipe);
        }
        if (solidMaterial instanceof GemMaterial) {
            ToolRecipeHandler.addSimpleToolRecipe(toolPrefix, solidMaterial, toolItem, new UnificationEntry(OrePrefix.gem, solidMaterial), new UnificationEntry(OrePrefix.gem, solidMaterial), recipe);
        }
    }

    public static void processStick(OrePrefix stickPrefix, SolidMaterial material) {
        if (material.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
            return;
        }
        if (material instanceof IngotMaterial && material.toolDurability > 0) {
            ModHandler.addShapedRecipe(String.format("plunger_%s", material), MetaItems.PLUNGER.getStackForm(material), "xRR", " SR", "S f", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.plate, Materials.Rubber));
        }
        RoughSolidMaterial handleMaterial = Materials.Wood;
        if (material.hasFlag(SolidMaterial.MatFlags.GENERATE_ROD) && material.toolDurability > 0) {
            ModHandler.addShapedRecipe(String.format("screwdriver_%s_%s", material.toString(), handleMaterial.toString()), MetaItems.SCREWDRIVER.getStackForm(material), " fS", " Sh", "W  ", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('W'), new UnificationEntry(OrePrefix.stick, handleMaterial));
            ModHandler.addShapedRecipe(String.format("crowbar_%s", material), MetaItems.CROWBAR.getStackForm(material), "hDS", "DSD", "SDf", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('D'), new UnificationEntry(OrePrefix.dye, (Material)MarkerMaterials.Color.COLORS.get((Object)EnumDyeColor.BLUE)));
            ModHandler.addShapedRecipe(String.format("scoop_%s", material.toString()), MetaItems.SCOOP.getStackForm(material), "SWS", "SSS", "xSh", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        }
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE) && material.toolDurability > 0) {
            ModHandler.addShapedRecipe(String.format("knife_%s", material.toString()), MetaItems.KNIFE.getStackForm(material), "fPh", " S ", Character.valueOf('S'), new UnificationEntry(stickPrefix, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
        }
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD) && material.toolDurability > 0) {
            ModHandler.addShapedRecipe(String.format("butchery_knife_%s", material.toString()), MetaItems.BUTCHERY_KNIFE.getStackForm(material), "PPf", "PP ", "Sh ", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
        }
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD | IngotMaterial.MatFlags.GENERATE_BOLT_SCREW) && material.toolDurability > 0) {
            ModHandler.addShapedRecipe(String.format("wire_cutter_%s", material.toString()), MetaItems.WIRE_CUTTER.getStackForm(material), "PfP", "hPd", "STS", Character.valueOf('S'), new UnificationEntry(stickPrefix, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('T'), new UnificationEntry(OrePrefix.screw, material));
            ModHandler.addShapedRecipe(String.format("branch_cutter_%s", material.toString()), MetaItems.BRANCH_CUTTER.getStackForm(material), "PfP", "PdP", "STS", Character.valueOf('S'), new UnificationEntry(stickPrefix, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('T'), new UnificationEntry(OrePrefix.screw, material));
        }
    }

    public static void processLongStick(OrePrefix orePrefix, IngotMaterial material) {
        if (material.toolDurability <= 0) {
            return;
        }
        ToolRecipeHandler.processSimpleElectricToolHead(orePrefix, material, new ToolMetaItem.MetaToolValueItem[]{MetaItems.SCREWDRIVER_LV});
        for (MetaItem.MetaValueItem batteryItem : batteryItems[2]) {
            ItemStack batteryStack = batteryItem.getStackForm();
            long maxCharge = ((IElectricItem)batteryStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)).getMaxCharge();
            ItemStack chargedHammerStack = MetaItems.JACKHAMMER.getMaxChargeOverrideStack(material, maxCharge);
            String recipeNameFirst = String.format("jack_hammer_%s_%s_full", batteryItem.unlocalizedName, material.toString());
            ModHandler.addShapedEnergyTransferRecipe(recipeNameFirst, chargedHammerStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{batteryStack}), false, "SXd", "PRP", "MPB", Character.valueOf('X'), new UnificationEntry(OrePrefix.stickLong, material), Character.valueOf('M'), MetaItems.ELECTRIC_PISTON_HV.getStackForm(), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Titanium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plateDense, Materials.Titanium), Character.valueOf('R'), new UnificationEntry(OrePrefix.spring, Materials.Titanium), Character.valueOf('B'), batteryStack);
        }
        ItemStack drillStack = MetaItems.JACKHAMMER.getStackForm(material);
        ItemStack powerUnitStack = MetaItems.JACKHAMMER_BASE.getStackForm();
        String recipeNameSecond = String.format("jack_hammer_%s_unit", material);
        ModHandler.addShapedEnergyTransferRecipe(recipeNameSecond, drillStack, (Predicate<ItemStack>)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{powerUnitStack}), true, "wHd", " U ", Character.valueOf('H'), new UnificationEntry(orePrefix, material), Character.valueOf('U'), powerUnitStack);
    }

    public static void processDrillHead(OrePrefix drillHead, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleElectricToolHead(drillHead, solidMaterial, new ToolMetaItem.MetaToolValueItem[]{MetaItems.DRILL_LV, MetaItems.DRILL_MV, MetaItems.DRILL_HV});
        ModHandler.addShapedRecipe(String.format("drill_head_%s", solidMaterial.toString()), OreDictUnifier.get(OrePrefix.toolHeadDrill, solidMaterial), "XSX", "XSX", "ShS", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, solidMaterial), Character.valueOf('S'), new UnificationEntry(OrePrefix.plate, Materials.Steel));
    }

    public static void processChainSawHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleElectricToolHead(toolPrefix, solidMaterial, new ToolMetaItem.MetaToolValueItem[]{MetaItems.CHAINSAW_LV, MetaItems.CHAINSAW_MV, MetaItems.CHAINSAW_HV});
        ModHandler.addShapedRecipe(String.format("chainsaw_head_%s", solidMaterial.toString()), OreDictUnifier.get(toolPrefix, solidMaterial), "SRS", "XhX", "SRS", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, solidMaterial), Character.valueOf('S'), new UnificationEntry(OrePrefix.plate, Materials.Steel), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Steel));
    }

    public static void processWrenchHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleElectricToolHead(toolPrefix, solidMaterial, new ToolMetaItem.MetaToolValueItem[]{MetaItems.WRENCH_LV, MetaItems.WRENCH_MV, MetaItems.WRENCH_HV});
        ModHandler.addShapedRecipe(String.format("wrench_head_%s", solidMaterial.toString()), OreDictUnifier.get(OrePrefix.toolHeadWrench, solidMaterial), "hXW", "XRX", "WXd", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, solidMaterial), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Steel), Character.valueOf('W'), new UnificationEntry(OrePrefix.screw, Materials.Steel));
    }

    public static void processBuzzSawHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleElectricToolHead(toolPrefix, solidMaterial, new ToolMetaItem.MetaToolValueItem[]{MetaItems.BUZZSAW});
        ModHandler.addShapedRecipe(String.format("buzzsaw_head_%s", solidMaterial.toString()), OreDictUnifier.get(OrePrefix.toolHeadBuzzSaw, solidMaterial), "wXh", "X X", "fXx", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, solidMaterial));
    }

    public static void processScrewdriverHead(OrePrefix toolPrefix, Material material) {
        if (!(material instanceof SolidMaterial)) {
            return;
        }
        SolidMaterial solidMaterial = (SolidMaterial)material;
        ToolRecipeHandler.processSimpleElectricToolHead(toolPrefix, solidMaterial, new ToolMetaItem.MetaToolValueItem[]{MetaItems.SCREWDRIVER_LV});
        ModHandler.addShapedRecipe(String.format("screwdriver_head_%s", solidMaterial.toString()), OreDictUnifier.get(OrePrefix.toolHeadScrewdriver, solidMaterial), "fX", "Xh", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, solidMaterial));
    }

    public static void addSimpleToolRecipe(OrePrefix toolPrefix, SolidMaterial solidMaterial, ToolMetaItem.MetaToolValueItem toolItem, UnificationEntry plate, UnificationEntry ingot, Object[] recipe) {
        ArrayList<Character> usedChars = new ArrayList<Character>();
        for (Object object : recipe) {
            char[] chars;
            if (!(object instanceof String)) continue;
            for (char character : chars = ((String)object).toCharArray()) {
                usedChars.add(Character.valueOf(character));
            }
        }
        if (usedChars.contains(Character.valueOf('P'))) {
            recipe = ArrayUtils.addAll((Object[])recipe, (Object[])new Object[]{Character.valueOf('P'), plate});
        }
        if (usedChars.contains(Character.valueOf('I'))) {
            recipe = ArrayUtils.addAll((Object[])recipe, (Object[])new Object[]{Character.valueOf('I'), ingot});
        }
        ModHandler.addShapedRecipe(String.format("head_%s_%s", toolPrefix.name(), solidMaterial.toString()), OreDictUnifier.get(toolPrefix, solidMaterial), recipe);
    }

    public static void processAxeHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.AXE, "PIh", "P  ", "f  ");
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 3)).notConsumable(MetaItems.SHAPE_EXTRUDER_AXE)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 3)).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    public static void processHoeHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.HOE, "PIh", "f  ");
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 3)).notConsumable(MetaItems.SHAPE_EXTRUDER_HOE)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 3)).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    public static void processPickaxeHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.PICKAXE, "PII", "f h");
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 3)).notConsumable(MetaItems.SHAPE_EXTRUDER_PICKAXE)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 3)).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    public static void processSawHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.SAW, "PP", "fh");
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 2)).notConsumable(MetaItems.SHAPE_EXTRUDER_SAW)).outputs(OreDictUnifier.get(OrePrefix.toolHeadSaw, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 2)).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    public static void processSenseHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.SENSE, "PPI", "hf ");
    }

    public static void processShovelHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.SHOVEL, "fPh");
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial)).notConsumable(MetaItems.SHAPE_EXTRUDER_SHOVEL)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass())).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    public static void processSwordHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.SWORD, " P ", "fPh");
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 2)).notConsumable(MetaItems.SHAPE_EXTRUDER_SWORD)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 2)).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    public static void processSpadeHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.UNIVERSAL_SPADE, "PPP", "IhI", " I ");
    }

    public static void processHammerHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        if (!solidMaterial.hasFlag(DustMaterial.MatFlags.NO_WORKING)) {
            ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.HARD_HAMMER, "II ", "IIh", "II ");
        }
        RoughSolidMaterial handleMaterial = Materials.Wood;
        if (!solidMaterial.hasFlag(DustMaterial.MatFlags.NO_WORKING)) {
            ModHandler.addShapedRecipe(String.format("hammer_%s", solidMaterial.toString()), MetaItems.HARD_HAMMER.getStackForm(solidMaterial), "XX ", "XXS", "XX ", Character.valueOf('X'), new UnificationEntry(OrePrefix.ingot, solidMaterial), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, handleMaterial));
        }
        if (!solidMaterial.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
            int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 6)).notConsumable(MetaItems.SHAPE_EXTRUDER_HAMMER)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 6)).EUt(8 * voltageMultiplier)).buildAndRegister();
        }
    }

    public static void processFileHead(OrePrefix toolPrefix, SolidMaterial solidMaterial) {
        ToolRecipeHandler.processSimpleToolHead(toolPrefix, solidMaterial, MetaItems.FILE, " I ", " I ", " fh");
        if (solidMaterial instanceof IngotMaterial) {
            RoughSolidMaterial handleMaterial = Materials.Wood;
            ModHandler.addShapedRecipe(String.format("file_%s", solidMaterial), MetaItems.FILE.getStackForm(solidMaterial), "P", "P", "S", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, solidMaterial), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, handleMaterial));
        }
        int voltageMultiplier = ToolRecipeHandler.getVoltageMultiplier(solidMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, solidMaterial, 2)).notConsumable(MetaItems.SHAPE_EXTRUDER_FILE)).outputs(OreDictUnifier.get(toolPrefix, solidMaterial))).duration((int)solidMaterial.getAverageMass() * 2)).EUt(8 * voltageMultiplier)).buildAndRegister();
    }

    private static int getVoltageMultiplier(Material material) {
        return material instanceof IngotMaterial && ((IngotMaterial)material).blastFurnaceTemperature >= 2800 ? 32 : 8;
    }
}

