/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import shadows.endertweaker.EnderTweaker;
import shadows.endertweaker.RecipeUtils;
import shadows.endertweaker.recipe.RecipeInput;
import shadows.endertweaker.recipe.SagRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.SagMill")
@ZenRegister
public class SagMill {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, float[] chances, IIngredient input, @Optional String bonusType, @Optional int energyCost, @Optional float[] xp) {
        float[] xpa;
        if (xp == null) {
            xp = new float[output.length];
            Arrays.fill(xp, 0.0f);
        }
        if (SagMill.hasErrors(output, chances, input, xpa = xp, bonusType)) {
            return;
        }
        EnderTweaker.ADDITIONS.add(() -> {
            SagRecipe recipe = new SagRecipe(new RecipeInput(CraftTweakerMC.getIngredient((IIngredient)input)), energyCost <= 0 ? 5000 : energyCost, RecipeBonusType.valueOf((String)(Strings.isNullOrEmpty((String)bonusType) ? "NONE" : bonusType)), RecipeUtils.toEIOOutputs(output, chances, xpa));
            SagMillRecipeManager.getInstance().addRecipe((Recipe)recipe);
        });
    }

    @ZenMethod
    public static void addRecipe(WeightedItemStack[] output, IIngredient input, @Optional String bonusType, @Optional int energyCost, @Optional float[] xp) {
        float[] xpa;
        if (xp == null) {
            xp = new float[output.length];
            Arrays.fill(xp, 0.0f);
        }
        if (SagMill.hasErrors(output, input, xpa = xp, bonusType)) {
            return;
        }
        EnderTweaker.ADDITIONS.add(() -> {
            SagRecipe recipe = new SagRecipe(new RecipeInput(CraftTweakerMC.getIngredient((IIngredient)input)), energyCost <= 0 ? 5000 : energyCost, RecipeBonusType.valueOf((String)(Strings.isNullOrEmpty((String)bonusType) ? "NONE" : bonusType)), RecipeUtils.toEIOOutputs(output, xpa));
            SagMillRecipeManager.getInstance().addRecipe((Recipe)recipe);
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        if (input == null) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from sag mill.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)input);
            IRecipe rec = SagMillRecipeManager.getInstance().getRecipeForInput(RecipeLevel.IGNORE, stack);
            if (rec != null) {
                SagMillRecipeManager.getInstance().getRecipes().remove((Object)rec);
            } else {
                CraftTweakerAPI.logError((String)("No Sag Mill recipe found for " + stack.func_82833_r()));
            }
        });
    }

    public static boolean hasErrors(IItemStack[] output, float[] chances, IIngredient input, float[] xp, String type) {
        if (output == null || output.length == 0) {
            CraftTweakerAPI.logError((String)("Invalid output (empty or null) in Sag Mill recipe: " + output));
            return true;
        }
        if (output.length > 4) {
            CraftTweakerAPI.logError((String)("Invalid output (more than four entries) in Sag Mill recipe: " + RecipeUtils.getDisplayString((IIngredient[])output)));
            return true;
        }
        if (output.length != chances.length) {
            CraftTweakerAPI.logError((String)("Invalid output chances (chances do not match outputs) in Sag Mill recipe: " + RecipeUtils.getDisplayString((IIngredient[])output) + " | " + chances));
            return true;
        }
        if (output.length != xp.length) {
            CraftTweakerAPI.logError((String)("Invalid output xp (xp does not match outputs) in Sag Mill recipe: " + RecipeUtils.getDisplayString((IIngredient[])output) + " | " + xp));
            return true;
        }
        if (input == null) {
            CraftTweakerAPI.logError((String)"Invalid null Sag Mill input.");
            return true;
        }
        if (RecipeBonusType.valueOf((String)(Strings.isNullOrEmpty((String)type) ? "NONE" : type)) == null) {
            CraftTweakerAPI.logError((String)("Invalid bonus type in Sag Mill recipe: " + type + ". Valid values are NONE, MULTIPLY_OUTPUT, and CHANCE_ONLY."));
            return true;
        }
        return false;
    }

    public static boolean hasErrors(WeightedItemStack[] output, IIngredient input, float[] xp, String type) {
        if (output == null || output.length == 0) {
            CraftTweakerAPI.logError((String)("Invalid output (empty or null) in Sag Mill recipe: " + output));
            return true;
        }
        if (output.length > 4) {
            CraftTweakerAPI.logError((String)("Invalid output (more than four entries) in Sag Mill recipe: " + RecipeUtils.getDisplayString(output)));
            return true;
        }
        if (output.length != xp.length) {
            CraftTweakerAPI.logError((String)("Invalid output xp (xp does not match outputs) in Sag Mill recipe: " + RecipeUtils.getDisplayString(output) + " | " + xp));
            return true;
        }
        if (input == null) {
            CraftTweakerAPI.logError((String)"Invalid null Sag Mill input.");
            return true;
        }
        if (RecipeBonusType.valueOf((String)(Strings.isNullOrEmpty((String)type) ? "NONE" : type)) == null) {
            CraftTweakerAPI.logError((String)("Invalid bonus type in Sag Mill recipe: " + type + ". Valid values are NONE, MULTIPLY_OUTPUT, and CHANCE_ONLY."));
            return true;
        }
        return false;
    }
}

