/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class OldProfiler {
    public String currentSection = "";
    public Stack<Section> sectionStack = new Stack();
    public Map<String, Long> sectionTimeMap = new HashMap<String, Long>();
    public Map<String, Long> sectionCallCount = new HashMap<String, Long>();
    public List<String> sectionList = new LinkedList<String>();
    public boolean enabled = true;

    public void startSection(String name) {
        if (!this.enabled) {
            return;
        }
        name = name.replaceAll("\\.", ",");
        if (this.currentSection.length() > 0) {
            this.currentSection = this.currentSection + ".";
        }
        this.currentSection = this.currentSection + name;
        this.sectionStack.push(new Section(this.currentSection));
        if (!this.sectionList.contains(this.currentSection)) {
            this.sectionList.add(this.currentSection);
        }
        this.sectionTimeMap.putIfAbsent(this.currentSection, 0L);
        this.sectionCallCount.put(this.currentSection, this.sectionCallCount.getOrDefault(this.currentSection, 0L) + 1L);
    }

    public void endSection() {
        if (!this.enabled || this.sectionStack.isEmpty()) {
            return;
        }
        Section current = this.sectionStack.pop();
        long time = current.getTimeElapsed();
        Long t = this.sectionTimeMap.get(current.name);
        this.sectionTimeMap.put(current.name, t == null ? time : time + t);
        this.currentSection = this.sectionStack.isEmpty() ? "" : this.sectionStack.peek().name;
    }

    public void finish() {
        if (!this.enabled) {
            return;
        }
        StringBuilder builder = new StringBuilder("\n");
        Iterator<String> iterator = this.sectionList.iterator();
        while (iterator.hasNext()) {
            String section;
            String s = section = iterator.next();
            int depth = 0;
            while (s.contains(".")) {
                s = s.replaceFirst("\\.", "");
                ++depth;
            }
            String name = section.contains(".") ? section.substring(section.lastIndexOf(".") + 1) : section;
            builder.append(this.indent(depth)).append(name).append(": ").append((double)this.sectionTimeMap.get(section).longValue() / 1000000.0).append("ms | ").append(this.sectionCallCount.get(section)).append(" Calls\n");
        }
        LogHelperBC.dev(builder.toString());
        this.currentSection = "";
        this.sectionStack.clear();
        this.sectionTimeMap.clear();
        this.sectionCallCount.clear();
        this.sectionList.clear();
    }

    private String indent(int depth) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            s.append("|  ");
        }
        return s.toString();
    }

    public void endStartSection(String name) {
        this.endSection();
        this.startSection(name);
    }

    public static class Section {
        public String name;
        public long startTime;

        public Section(String name) {
            this.name = name;
            this.startTime = System.nanoTime();
        }

        public long getTimeElapsed() {
            return System.nanoTime() - this.startTime;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

