/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableDumper {
    public static final LootTableDumper DEFAULT = new LootTableDumper(new File("dumps/loot_tables"));
    private static final Logger LOGGER = LogManager.getLogger();
    private final File dumpFolder;

    public LootTableDumper(File dumpFolder) {
        assert (dumpFolder.isDirectory()) : "Dump folder must be a directory";
        this.dumpFolder = dumpFolder;
        this.dumpFolder.mkdirs();
    }

    public File dump(World world, ResourceLocation tableId) {
        return this.dump(world.func_184146_ak().func_186521_a(tableId), tableId);
    }

    public File dump(LootTable lootTable, ResourceLocation tableId) {
        Preconditions.checkNotNull((Object)lootTable);
        File dump = new File(this.dumpFolder, tableId.func_110624_b() + '/' + tableId.func_110623_a() + ".json");
        try {
            dump.getParentFile().mkdirs();
            dump.createNewFile();
            try (FileWriter writer = new FileWriter(dump);){
                Gson gsonInstance = LootTableManagerAccessors.getGsonInstance();
                JsonWriter dumper = gsonInstance.newJsonWriter((Writer)writer);
                dumper.setIndent("  ");
                gsonInstance.toJson((Object)lootTable, lootTable.getClass(), dumper);
            }
            LOGGER.info("Loot table {} saved to {}", (Object)tableId, (Object)dump.getCanonicalPath());
            return dump;
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to dump loot table {}", (Object)tableId, (Object)t);
            return null;
        }
    }
}

