/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLinkBaseAbsolute;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureLinkFromSubWorld
extends StructureLinkBaseAbsolute<LittleStructure>
implements IStructureChildConnector<LittleStructure> {
    public final int childID;

    public StructureLinkFromSubWorld(LittleTile tile, int attribute, LittleStructure parent, int childID) {
        super(tile, attribute, parent);
        this.childID = childID;
    }

    public StructureLinkFromSubWorld(TileEntity te, LittleGridContext context, int[] identifier, int attribute, LittleStructure parent, int childID) {
        super(te, context, identifier, attribute, parent);
        this.childID = childID;
    }

    public StructureLinkFromSubWorld(BlockPos pos, LittleGridContext context, int[] identifier, int attribute, LittleStructure parent, int childID) {
        super(pos, context, identifier, attribute, parent);
        this.childID = childID;
    }

    public StructureLinkFromSubWorld(NBTTagCompound nbt, LittleStructure parent) {
        super(nbt, parent);
        this.childID = nbt.func_74762_e("childID");
    }

    @Override
    protected World getWorld(World world) {
        return ((SubWorld)((LittleStructure)this.parent).getWorld()).parentWorld;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74768_a("childID", this.childID);
        nbt.func_74757_a("subWorld", true);
        return nbt;
    }

    @Override
    protected void connect(World world, LittleTile mainTile) {
        this.connectedStructure = mainTile.connection.getStructureWithoutLoading();
        IStructureChildConnector link = this.connectedStructure.children.get(this.childID);
        if (link == null) {
            new RuntimeException("Parent does not remember child! coord=" + this).printStackTrace();
            return;
        }
        link.setLoadedStructure((LittleStructure)this.parent);
    }

    @Override
    protected void failedConnect(World world) {
        new RuntimeException("Failed to connect to parent/ child structure! coord=" + this + "").printStackTrace();
    }

    public StructureLinkFromSubWorld copy(LittleStructure parent) {
        return new StructureLinkFromSubWorld(this.pos, this.context, (int[])this.identifier.clone(), this.attribute, parent, this.childID);
    }

    @Override
    public boolean isChild() {
        return true;
    }

    @Override
    public int getChildID() {
        return this.childID;
    }

    @Override
    public void destroyStructure() {
        SubWorld fakeWorld = (SubWorld)((LittleStructure)this.parent).getWorld();
        ((EntityAnimation)fakeWorld.parent).markRemoved();
        ((LittleStructure)this.parent).onStructureDestroyed();
    }

    @Override
    public boolean isLinkToAnotherWorld() {
        return true;
    }

    @Override
    public EntityAnimation getAnimation() {
        SubWorld fakeWorld = (SubWorld)((LittleStructure)this.parent).getWorld();
        return (EntityAnimation)fakeWorld.parent;
    }
}

