/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box.slice;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.math.vec.IVecInt;
import com.creativemd.creativecore.common.utils.math.vec.Ray2d;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.client.render.tile.LittleSlicedOrdinaryRenderingCube;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.LittleUtils;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.slice.AxisAlignedBBOrdinarySliced;
import com.creativemd.littletiles.common.tile.math.box.slice.LittleSlice;
import com.creativemd.littletiles.common.tile.math.box.slice.LittleSlicedBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSlicedOrdinaryBox
extends LittleBox {
    public LittleSlice slice;

    public LittleSlicedOrdinaryBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LittleSlice slice) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.slice = slice;
    }

    public LittleSlicedOrdinaryBox(LittleBox box, LittleSlice slice) {
        this(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, slice);
    }

    @Override
    public AxisAlignedBB getSelectionBox(LittleGridContext context, BlockPos pos) {
        return super.getBox(context, pos);
    }

    public AxisAlignedBBOrdinarySliced getBox(LittleGridContext context, BlockPos offset) {
        return new AxisAlignedBBOrdinarySliced(context.toVanillaGrid(this.minX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.minY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.minZ) + (double)offset.func_177952_p(), context.toVanillaGrid(this.maxX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.maxY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.maxZ) + (double)offset.func_177952_p(), this.slice);
    }

    public AxisAlignedBBOrdinarySliced getBox(LittleGridContext context) {
        return new AxisAlignedBBOrdinarySliced(context.toVanillaGrid(this.minX), context.toVanillaGrid(this.minY), context.toVanillaGrid(this.minZ), context.toVanillaGrid(this.maxX), context.toVanillaGrid(this.maxY), context.toVanillaGrid(this.maxZ), this.slice);
    }

    @Override
    public int[] getArray() {
        return new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.slice.getSliceID()};
    }

    @Override
    public boolean isCompletelyFilled() {
        return false;
    }

    @Override
    public double getVolume() {
        return super.getVolume() * 0.5;
    }

    @Override
    public boolean doesFillEntireBlock(LittleGridContext context) {
        return false;
    }

    @Override
    public LittleBox createOutsideBlockBox(LittleGridContext context, EnumFacing facing) {
        if (facing == this.slice.emptySideOne || facing == this.slice.emptySideTwo) {
            return null;
        }
        if (facing.func_176740_k() == this.slice.axis) {
            LittleSlicedOrdinaryBox box = this.copy();
            switch (facing) {
                case EAST: {
                    box.minX = 0;
                    box.maxX -= context.size;
                    break;
                }
                case WEST: {
                    box.minX += context.size;
                    box.maxX = context.size;
                    break;
                }
                case UP: {
                    box.minY = 0;
                    box.maxY -= context.size;
                    break;
                }
                case DOWN: {
                    box.minY += context.size;
                    box.maxY = context.size;
                    break;
                }
                case SOUTH: {
                    box.minZ = 0;
                    box.maxZ -= context.size;
                    break;
                }
                case NORTH: {
                    box.minZ += context.size;
                    box.maxZ = context.size;
                }
            }
            return box;
        }
        return super.createOutsideBlockBox(context, facing);
    }

    @Override
    public LittleBox combineBoxes(LittleBox box, BasicCombiner combiner) {
        if (box instanceof LittleSlicedOrdinaryBox && ((LittleSlicedOrdinaryBox)box).isOrdinary() && ((LittleSlicedOrdinaryBox)box).slice == this.slice) {
            EnumFacing facing = this.sharedBoxFace(box);
            if (facing != null) {
                if (facing.func_176740_k() == this.slice.axis) {
                    LittleSlicedOrdinaryBox newBox = this.copy();
                    if (facing.func_176743_c() != EnumFacing.AxisDirection.POSITIVE) {
                        newBox.setMax(this.slice.axis, box.getMax(this.slice.axis));
                    } else {
                        newBox.setMin(this.slice.axis, box.getMin(this.slice.axis));
                    }
                    return newBox;
                }
            } else if (this.getMin(this.slice.axis) == box.getMin(this.slice.axis) && this.getMax(this.slice.axis) == box.getMax(this.slice.axis)) {
                boolean shareTwoNegative;
                EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
                EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
                boolean shareOnePostive = this.getMax(one) == box.getMin(one);
                boolean shareOneNegative = this.getMin(one) == box.getMax(one);
                boolean shareTwoPostive = this.getMax(two) == box.getMin(two);
                boolean bl = shareTwoNegative = this.getMin(two) == box.getMax(two);
                if (shareOnePostive ^ shareOneNegative && shareTwoPostive ^ shareTwoNegative) {
                    boolean postiveOne = this.slice.isFacingPositive(one);
                    boolean postiveTwo = this.slice.isFacingPositive(two);
                    if (postiveOne == shareOnePostive && postiveTwo == shareTwoPostive || postiveOne != shareOnePostive && postiveTwo != shareTwoPostive) {
                        return null;
                    }
                    if (this.getSliceAngle(one, two) != ((LittleSlicedOrdinaryBox)box).getSliceAngle(one, two)) {
                        return null;
                    }
                    LittleBox boxInBetween = new LittleBox(this);
                    if (shareOnePostive != postiveOne) {
                        boxInBetween.setMin(one, box.getMin(one));
                        boxInBetween.setMax(one, box.getMax(one));
                    }
                    if (shareTwoPostive != postiveTwo) {
                        boxInBetween.setMin(two, box.getMin(two));
                        boxInBetween.setMax(two, box.getMax(two));
                    }
                    if (combiner.cutOut(boxInBetween)) {
                        LittleSlicedOrdinaryBox newBox = this.copy();
                        if (shareOnePostive) {
                            newBox.setMax(one, box.getMax(one));
                        } else {
                            newBox.setMin(one, box.getMin(one));
                        }
                        if (shareTwoPostive) {
                            newBox.setMax(two, box.getMax(two));
                        } else {
                            newBox.setMin(two, box.getMin(two));
                        }
                        return newBox;
                    }
                }
            }
        }
        return null;
    }

    public boolean isVecInsideBoxNoEdge(Vec3d vec) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        double posOne = RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec);
        double posTwo = RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec);
        if (posOne >= (double)this.getMin(one) && posOne < (double)this.getMax(one) && posTwo >= (double)this.getMin(two) && posTwo < (double)this.getMax(two)) {
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs((double)this.getCornerValue(corner, one) - posOne);
            double difTwo = Math.abs((double)this.getCornerValue(corner, two) - posTwo);
            double sizeOne = this.getSize(one);
            double sizeTwo = this.getSize(two);
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne > difOne && sizeTwo > difTwo && diff < 1.0;
        }
        return false;
    }

    protected boolean intersectsWithBetweenSliceAndBox(LittleBox box) {
        if (box instanceof LittleSlicedOrdinaryBox) {
            return this.intersectsWithBetweenSliceAndBoxInternally(box) && ((LittleSlicedOrdinaryBox)box).intersectsWithBetweenSliceAndBoxInternally(this);
        }
        return this.intersectsWithBetweenSliceAndBoxInternally(box);
    }

    protected boolean intersectsWithBetweenSliceAndBoxInternally(LittleBox box) {
        EnumFacing ignoreFace = RotationUtils.getFacing((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis axisOne = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis axisTwo = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        BoxUtils.BoxCorner cornerMin = BoxUtils.BoxCorner.getCornerUnsorted((EnumFacing)ignoreFace, (EnumFacing)this.slice.emptySideOne.func_176734_d(), (EnumFacing)this.slice.emptySideTwo.func_176734_d());
        BoxUtils.BoxCorner cornerMax = BoxUtils.BoxCorner.getCornerUnsorted((EnumFacing)ignoreFace, (EnumFacing)this.slice.emptySideOne, (EnumFacing)this.slice.emptySideTwo);
        int pointOne = this.getValueOfFacing(this.slice.getEmptySide(axisOne).func_176734_d());
        int pointTwo = this.getValueOfFacing(this.slice.getEmptySide(axisTwo).func_176734_d());
        LittleVec minVec = box.getCorner(cornerMin);
        LittleVec maxVec = box.getCorner(cornerMax);
        minVec.set(this.slice.axis, this.getValueOfFacing(ignoreFace.func_176734_d()));
        maxVec.set(this.slice.axis, this.getValueOfFacing(ignoreFace.func_176734_d()));
        if (this.isVecInsideBoxNoEdge(box.getExactCorner(cornerMin))) {
            return true;
        }
        if (this.isVecInsideBoxNoEdge(box.getExactCorner(cornerMax))) {
            return true;
        }
        if (this.slice.isFacingPositive(axisOne) ? minVec.get(axisOne) <= pointOne : minVec.get(axisOne) >= pointOne) {
            return true;
        }
        return this.slice.isFacingPositive(axisTwo) ? minVec.get(axisTwo) <= pointTwo : minVec.get(axisTwo) >= pointTwo;
    }

    @Override
    protected boolean intersectsWith(LittleBox box) {
        if (!super.intersectsWith(box)) {
            return false;
        }
        if (this.intersectsWithBetweenSliceAndBox(box)) {
            if (box.getClass() == LittleBox.class) {
                return true;
            }
            if (box instanceof LittleSlicedOrdinaryBox) {
                LittleSlicedOrdinaryBox sliceBox = (LittleSlicedOrdinaryBox)box;
                if (sliceBox.slice.axis != this.slice.axis || sliceBox.slice.getOpposite() != this.slice) {
                    return true;
                }
                Vector3d vec = this.getSliceLine().intersect(((LittleSlicedOrdinaryBox)box).getSliceLine(), this.getMin(this.slice.axis));
                return sliceBox.slice.getOpposite() == this.slice == (vec == null ? false : this.isVecInsideBoxRelative(new Vec3d(vec.x, vec.y, vec.z)));
            }
        }
        return false;
    }

    public boolean isVecInsideBoxRelative(Vec3d vec) {
        if (vec.field_72450_a >= (double)this.minX && vec.field_72450_a < (double)this.maxX && vec.field_72448_b >= (double)this.minY && vec.field_72448_b < (double)this.maxY && vec.field_72449_c >= (double)this.minZ && vec.field_72449_c < (double)this.maxZ) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs((double)this.getCornerValue(corner, one) - RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec));
            double difTwo = Math.abs((double)this.getCornerValue(corner, two) - RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec));
            int sizeOne = this.getSize(one);
            int sizeTwo = this.getSize(two);
            double diff = difOne / (double)sizeOne + difTwo / (double)sizeTwo;
            return (double)sizeOne >= difOne && (double)sizeTwo >= difTwo && diff <= 1.0;
        }
        return false;
    }

    @Override
    public boolean isVecInsideBox(int x, int y, int z) {
        if (super.isVecInsideBox(x, y, z)) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            int posOne = RotationUtils.get((EnumFacing.Axis)one, (int)x, (int)y, (int)z);
            int posTwo = RotationUtils.get((EnumFacing.Axis)two, (int)x, (int)y, (int)z);
            if (!this.slice.isFacingPositive(one)) {
                ++posOne;
            }
            if (!this.slice.isFacingPositive(two)) {
                ++posTwo;
            }
            int difOne = Math.abs(this.getCornerValue(corner, one) - posOne);
            int difTwo = Math.abs(this.getCornerValue(corner, two) - posTwo);
            int sizeOne = this.getSize(one);
            int sizeTwo = this.getSize(two);
            double diff = (double)difOne / (double)sizeOne + (double)difTwo / (double)sizeTwo;
            return sizeOne > difOne && sizeTwo > difTwo && diff < 1.0 && !LittleUtils.equals(diff, 1.0);
        }
        return false;
    }

    @Override
    public boolean isVecInsideBox(LittleBox box, LittleVec vec) {
        if (box.isCompletelyFilled()) {
            return this.isVecInsideBox(vec.x, vec.y, vec.z);
        }
        LittleBox box2 = this.extractBox(vec.x, vec.y, vec.z);
        if (box2 != null) {
            return LittleBox.intersectsWith(box, box2);
        }
        return false;
    }

    @Override
    public boolean canFaceBeCombined(LittleBox other) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        return other instanceof LittleSlicedOrdinaryBox && ((LittleSlicedOrdinaryBox)other).slice == this.slice && ((LittleSlicedOrdinaryBox)other).getSliceAngle(one, two) == this.getSliceAngle(one, two);
    }

    @Override
    public boolean intersectsWithFace(EnumFacing facing, LittleVec vec, boolean completely) {
        if (!super.intersectsWithFace(facing, vec, completely)) {
            return false;
        }
        if (facing.func_176740_k() == this.slice.axis) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            LittleVec copy = vec.copy();
            if (completely == this.slice.isFacingPositive(one)) {
                copy.set(one, copy.get(one) + 1);
            }
            if (completely == this.slice.isFacingPositive(two)) {
                copy.set(two, copy.get(two) + 1);
            }
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getCornerValue(corner, one) - copy.get(one));
            double difTwo = Math.abs(this.getCornerValue(corner, two) - copy.get(two));
            double sizeOne = this.getSize(one);
            double sizeTwo = this.getSize(two);
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne > difOne && sizeTwo > difTwo && diff < 1.0;
        }
        return this.slice.getEmptySide(facing.func_176740_k()) != facing;
    }

    @Override
    public boolean intersectsWithAxis(LittleGridContext context, EnumFacing.Axis axis, Vec3d vec) {
        if (!super.intersectsWithAxis(context, axis, vec)) {
            return false;
        }
        if (this.slice.axis == axis) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(context.toVanillaGrid(this.getCornerValue(corner, one)) - RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec));
            double difTwo = Math.abs(context.toVanillaGrid(this.getCornerValue(corner, two)) - RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec));
            double sizeOne = (double)this.getSize(one) / (double)context.size;
            double sizeTwo = (double)this.getSize(two) / (double)context.size;
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne >= difOne && sizeTwo >= difTwo && diff <= 1.0;
        }
        return true;
    }

    public static Vec3d linePlaneIntersection(Vec3d planeOrigin, Vec3d planeNormal, Vec3d rayOrigin, Vec3d rayDirection) {
        if (planeNormal.func_72430_b(rayDirection) == 0.0) {
            return null;
        }
        return rayOrigin.func_178787_e(rayDirection.func_186678_a(planeNormal.func_72430_b(planeOrigin.func_178788_d(rayOrigin)) / planeNormal.func_72430_b(rayDirection)));
    }

    @Override
    @Nullable
    public RayTraceResult calculateIntercept(LittleGridContext context, BlockPos pos, Vec3d vecA, Vec3d vecB) {
        vecA = vecA.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        vecB = vecB.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d collision = null;
        EnumFacing collided = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vec3d temp;
            if (this.slice.emptySideOne == facing || this.slice.emptySideTwo == facing || (temp = this.collideWithPlane(context, facing.func_176740_k(), (double)this.getValueOfFacing(facing) / (double)context.size, vecA, vecB)) == null || !LittleSlicedOrdinaryBox.isClosest(vecA, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        EnumFacing diagonal = this.slice.getPreferedSide(this.getSize());
        Vec3d temp = LittleSlicedOrdinaryBox.linePlaneIntersection(this.getCorner(this.slice.start).getVec(context), this.getSliceNormal(), vecA, vecB.func_178788_d(vecA));
        if (temp != null && this.intersectsWithAxis(context, diagonal.func_176740_k(), temp) && LittleSlicedOrdinaryBox.isClosest(vecA, collision, temp)) {
            collision = temp;
            collided = diagonal;
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collided, pos);
    }

    @Override
    public void rotateBox(Rotation rotation, LittleVec doubledCenter) {
        super.rotateBox(rotation, doubledCenter);
        this.slice = this.slice.rotate(rotation);
    }

    @Override
    public void flipBox(EnumFacing.Axis axis, LittleVec doubledCenter) {
        super.flipBox(axis, doubledCenter);
        this.slice = this.slice.flip(axis);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LittleSlicedOrdinaryBox) {
            return super.equals(object) && ((LittleSlicedOrdinaryBox)object).slice == this.slice;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "," + this.slice.name() + "]";
    }

    @Override
    public LittleSlicedOrdinaryBox copy() {
        return new LittleSlicedOrdinaryBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.slice);
    }

    public double getSliceAngle(EnumFacing.Axis one, EnumFacing.Axis two) {
        return (double)this.getSize(one) / (double)this.getSize(two);
    }

    public Vec3d getSliceNormal() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Vector3d vec = new Vector3d();
        RotationUtils.setValue((Tuple3d)vec, (double)(this.getSize(one) * this.slice.getDirectionScale(one)), (EnumFacing.Axis)one);
        RotationUtils.setValue((Tuple3d)vec, (double)(this.getSize(two) * this.slice.getDirectionScale(two)), (EnumFacing.Axis)two);
        RotationUtils.rotate((Vector3d)vec, (Rotation)Rotation.getRotation((EnumFacing.Axis)this.slice.axis, (boolean)this.slice.isRight));
        vec.normalize();
        return new Vec3d(vec.x, vec.y, vec.z);
    }

    public Ray2d getSliceLine() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        return new Ray2d(one, two, (IVecInt)this.getCorner(this.slice.start), (double)(this.getSize(one) * this.slice.getDirectionScale(one)), (double)(this.getSize(two) * this.slice.getDirectionScale(two)));
    }

    @Override
    public LittleBox extractBox(int x, int y, int z) {
        boolean endTwoIntersection;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Ray2d line = this.getSliceLine();
        int minOne = RotationUtils.get((EnumFacing.Axis)one, (int)x, (int)y, (int)z);
        int minTwo = RotationUtils.get((EnumFacing.Axis)two, (int)x, (int)y, (int)z);
        int maxOne = minOne + 1;
        int maxTwo = minTwo + 1;
        double startOne = line.get(two, this.slice.start.isFacingPositive(two) ? (double)maxTwo : (double)minTwo);
        double startTwo = line.get(one, this.slice.start.isFacingPositive(one) ? (double)maxOne : (double)minOne);
        double endOne = line.get(two, this.slice.start.isFacingPositive(two) ? (double)minTwo : (double)maxTwo);
        double endTwo = line.get(one, this.slice.start.isFacingPositive(one) ? (double)minOne : (double)maxOne);
        boolean startOneIntersection = startOne >= (double)minOne && startOne <= (double)maxOne;
        boolean startTwoIntersection = startTwo >= (double)minTwo && startTwo <= (double)maxTwo;
        boolean endOneIntersection = endOne >= (double)minOne && endOne <= (double)maxOne;
        boolean bl = endTwoIntersection = endTwo >= (double)minTwo && endTwo <= (double)maxTwo;
        if ((startOneIntersection || startTwoIntersection) && (endOneIntersection || endTwoIntersection)) {
            if (startOneIntersection) {
                startTwo = this.slice.start.isFacingPositive(two) ? (double)maxTwo : (double)minTwo;
            } else {
                double d = startOne = this.slice.start.isFacingPositive(one) ? (double)maxOne : (double)minOne;
            }
            if (endOneIntersection) {
                endTwo = this.slice.end.isFacingPositive(two) ? (double)maxTwo : (double)minTwo;
            } else {
                endOne = this.slice.end.isFacingPositive(one) ? (double)maxOne : (double)minOne;
            }
            int minBoxOne = Math.min((int)Math.floor(LittleUtils.round(startOne)), (int)Math.floor(LittleUtils.round(endOne)));
            int minBoxTwo = Math.min((int)Math.floor(LittleUtils.round(startTwo)), (int)Math.floor(LittleUtils.round(endTwo)));
            int maxBoxOne = Math.max((int)Math.ceil(LittleUtils.round(startOne)), (int)Math.ceil(LittleUtils.round(endOne)));
            int maxBoxTwo = Math.max((int)Math.ceil(LittleUtils.round(startTwo)), (int)Math.ceil(LittleUtils.round(endTwo)));
            LittleSlicedOrdinaryBox slicedBox = Math.min(startOne -= (double)minBoxOne, endOne -= (double)minBoxOne) == 0.0 && Math.min(startTwo, endTwo) == 0.0 && Math.max(startOne, endOne) == (double)(maxBoxOne - minBoxOne) && Math.max(startTwo, endTwo) == (double)(maxBoxTwo - minBoxTwo) ? new LittleSlicedOrdinaryBox(x, y, z, x + 1, y + 1, z + 1, this.slice) : new LittleSlicedBox(x, y, z, x + 1, y + 1, z + 1, this.slice, (float)startOne, (float)(startTwo -= (double)minBoxTwo), (float)endOne, (float)(endTwo -= (double)minBoxTwo));
            slicedBox.setMin(one, minBoxOne);
            slicedBox.setMin(two, minBoxTwo);
            slicedBox.setMax(one, maxBoxOne);
            slicedBox.setMax(two, maxBoxTwo);
            if (slicedBox.isValidBox()) {
                return slicedBox;
            }
            if (this.slice.isRight == (line.isCoordinateOnLine(minOne, minTwo) ? line.isCoordinateToTheRight(maxOne, maxTwo) : line.isCoordinateToTheRight(minOne, minTwo))) {
                return new LittleBox(x, y, z, x + 1, y + 1, z + 1);
            }
            return null;
        }
        if (this.slice.isRight == (line.isCoordinateOnLine(minOne, minTwo) ? line.isCoordinateToTheRight(maxOne, maxTwo) : line.isCoordinateToTheRight(minOne, minTwo))) {
            return new LittleBox(x, y, z, x + 1, y + 1, z + 1);
        }
        return null;
    }

    @Override
    public List<LittleBox> extractBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, List<LittleBox> boxes) {
        boolean endTwoIntersection;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Ray2d line = this.getSliceLine();
        int minOne = RotationUtils.get((EnumFacing.Axis)one, (int)minX, (int)minY, (int)minZ);
        int minTwo = RotationUtils.get((EnumFacing.Axis)two, (int)minX, (int)minY, (int)minZ);
        int maxOne = RotationUtils.get((EnumFacing.Axis)one, (int)maxX, (int)maxY, (int)maxZ);
        int maxTwo = RotationUtils.get((EnumFacing.Axis)two, (int)maxX, (int)maxY, (int)maxZ);
        double startOne = line.get(two, this.slice.start.isFacingPositive(two) ? (double)maxTwo : (double)minTwo);
        double startTwo = line.get(one, this.slice.start.isFacingPositive(one) ? (double)maxOne : (double)minOne);
        double endOne = line.get(two, this.slice.start.isFacingPositive(two) ? (double)minTwo : (double)maxTwo);
        double endTwo = line.get(one, this.slice.start.isFacingPositive(one) ? (double)minOne : (double)maxOne);
        boolean startOneIntersection = startOne >= (double)minOne && startOne <= (double)maxOne;
        boolean startTwoIntersection = startTwo >= (double)minTwo && startTwo <= (double)maxTwo;
        boolean endOneIntersection = endOne >= (double)minOne && endOne <= (double)maxOne;
        boolean bl = endTwoIntersection = endTwo >= (double)minTwo && endTwo <= (double)maxTwo;
        if ((startOneIntersection || startTwoIntersection) && (endOneIntersection || endTwoIntersection)) {
            boolean hasAdditionalBoxOne;
            if (startOneIntersection) {
                startTwo = line.get(one, startOne);
            } else {
                startOne = line.get(two, startTwo);
            }
            if (endOneIntersection) {
                endTwo = line.get(one, endOne);
            } else {
                endOne = line.get(two, endTwo);
            }
            int minBoxOne = Math.min((int)Math.floor(LittleUtils.round(startOne)), (int)Math.floor(LittleUtils.round(endOne)));
            int minBoxTwo = Math.min((int)Math.floor(LittleUtils.round(startTwo)), (int)Math.floor(LittleUtils.round(endTwo)));
            int maxBoxOne = Math.max((int)Math.ceil(LittleUtils.round(startOne)), (int)Math.ceil(LittleUtils.round(endOne)));
            int maxBoxTwo = Math.max((int)Math.ceil(LittleUtils.round(startTwo)), (int)Math.ceil(LittleUtils.round(endTwo)));
            LittleSlicedOrdinaryBox slicedBox = Math.min(startOne -= (double)minBoxOne, endOne -= (double)minBoxOne) == 0.0 && Math.min(startTwo, endTwo) == 0.0 && Math.max(startOne, endOne) == (double)(maxBoxOne - minBoxOne) && Math.max(startTwo, endTwo) == (double)(maxBoxTwo - minBoxTwo) ? new LittleSlicedOrdinaryBox(minX, minY, minZ, maxX, maxY, maxZ, this.slice) : new LittleSlicedBox(minX, minY, minZ, maxX, maxY, maxZ, this.slice, (float)startOne, (float)(startTwo -= (double)minBoxTwo), (float)endOne, (float)(endTwo -= (double)minBoxTwo));
            slicedBox.setMin(one, minBoxOne);
            slicedBox.setMin(two, minBoxTwo);
            slicedBox.setMax(one, maxBoxOne);
            slicedBox.setMax(two, maxBoxTwo);
            if (slicedBox.isValidBox()) {
                boxes.add(slicedBox);
            } else if (this.slice.isRight != (line.isCoordinateOnLine(minOne, minTwo) ? line.isCoordinateToTheRight(maxOne, maxTwo) : line.isCoordinateToTheRight(minOne, minTwo))) {
                return boxes;
            }
            boolean postiveOne = this.slice.isFacingPositive(one);
            boolean postiveTwo = this.slice.isFacingPositive(two);
            boolean bl2 = postiveTwo == this.slice.start.isFacingPositive(two) ? !startTwoIntersection : (hasAdditionalBoxOne = !endTwoIntersection);
            boolean hasAdditionalBoxTwo = postiveOne == this.slice.start.isFacingPositive(one) ? !startOneIntersection : !endOneIntersection;
            int minAdditionalBoxOne = Math.min(postiveOne ? minOne : slicedBox.getMax(one), postiveOne ? slicedBox.getMin(one) : maxOne);
            int minAdditionalBoxTwo = Math.min(postiveTwo ? minTwo : slicedBox.getMax(two), postiveTwo ? slicedBox.getMin(two) : maxTwo);
            int maxAdditionalBoxOne = Math.max(postiveOne ? minOne : slicedBox.getMax(one), postiveOne ? slicedBox.getMin(one) : maxOne);
            int maxAdditionalBoxTwo = Math.max(postiveTwo ? minTwo : slicedBox.getMax(two), postiveTwo ? slicedBox.getMin(two) : maxTwo);
            if (hasAdditionalBoxOne && minAdditionalBoxOne >= maxAdditionalBoxOne) {
                hasAdditionalBoxOne = false;
            }
            if (hasAdditionalBoxTwo && minAdditionalBoxTwo >= maxAdditionalBoxTwo) {
                hasAdditionalBoxTwo = false;
            }
            if (hasAdditionalBoxOne) {
                LittleBox additionalBoxOne = new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
                additionalBoxOne.setMin(one, minAdditionalBoxOne);
                additionalBoxOne.setMax(one, maxAdditionalBoxOne);
                if (!hasAdditionalBoxTwo) {
                    if (postiveTwo) {
                        additionalBoxOne.setMin(two, minAdditionalBoxTwo);
                    } else {
                        additionalBoxOne.setMax(two, maxAdditionalBoxTwo);
                    }
                }
                if (additionalBoxOne.isValidBox()) {
                    boxes.add(additionalBoxOne);
                }
            }
            if (hasAdditionalBoxTwo) {
                LittleBox additionalBoxTwo = new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
                additionalBoxTwo.setMin(two, minAdditionalBoxTwo);
                additionalBoxTwo.setMax(two, maxAdditionalBoxTwo);
                if (postiveOne) {
                    additionalBoxTwo.setMin(one, maxAdditionalBoxOne);
                } else {
                    additionalBoxTwo.setMax(one, minAdditionalBoxOne);
                }
                if (additionalBoxTwo.isValidBox()) {
                    boxes.add(additionalBoxTwo);
                }
            }
        } else if (this.slice.isRight == (line.isCoordinateOnLine(minOne, minTwo) ? line.isCoordinateToTheRight(maxOne, maxTwo) : line.isCoordinateToTheRight(minOne, minTwo))) {
            boxes.add(new LittleBox(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return boxes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleRenderingCube getRenderingCube(LittleGridContext context, CubeObject cube, Block block, int meta) {
        return new LittleSlicedOrdinaryRenderingCube(cube, this, block, meta);
    }

    @Override
    public boolean isFaceSolid(EnumFacing facing) {
        return facing != this.slice.emptySideOne && facing != this.slice.emptySideTwo && facing.func_176740_k() != this.slice.axis;
    }

    @Override
    @Nullable
    public LittleBox.LittleTileFace getFace(LittleGridContext context, EnumFacing facing) {
        if (facing == this.slice.emptySideOne || facing == this.slice.emptySideTwo) {
            return null;
        }
        return super.getFace(context, facing);
    }

    public boolean isOrdinary() {
        return true;
    }

    @Override
    public int[] getIdentifier() {
        BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
        return new int[]{this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner), this.slice.ordinal()};
    }

    @Override
    public boolean is(int[] identifier) {
        if (identifier.length == 4 && identifier[3] == this.slice.ordinal()) {
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            return identifier[0] == this.getCornerX(corner) && identifier[1] == this.getCornerY(corner) && identifier[2] == this.getCornerZ(corner);
        }
        return false;
    }
}

