/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.compression;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LittleNBTCompressionTools {
    private static PreviewCompressionHandler defaultHandler = null;
    private static HashMap<String, PreviewCompressionHandler> handlers = new HashMap();
    public static PreviewCompressionHandler ordinaryPreviewHandler = new PreviewCompressionHandler(){

        @Override
        public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
            ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
            NBTTagList list = nbt.func_150295_c("boxes", 11);
            NBTTagCompound copy = new NBTTagCompound();
            for (String key : nbt.func_150296_c()) {
                if (key.equals("boxes") || key.equals("group")) continue;
                copy.func_74782_a(key, nbt.func_74781_a(key).func_74737_b());
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound second = copy.func_74737_b();
                second.func_74783_a("bBox", list.func_150306_c(i));
                tags.add(second);
            }
            return tags;
        }
    };

    public static NBTTagList writeTiles(List<LittleTile> tiles) {
        HashMapList groups = new HashMapList();
        for (LittleTile tile : tiles) {
            groups.add(tile.getClass(), (Object)tile);
        }
        NBTTagList list = new NBTTagList();
        for (ArrayList classList : groups.values()) {
            while (classList.size() > 0) {
                LittleTile grouping = (LittleTile)classList.remove(0);
                NBTTagCompound groupNBT = null;
                Iterator iterator2 = classList.iterator();
                while (iterator2.hasNext()) {
                    LittleTile littleTile = (LittleTile)iterator2.next();
                    if (!grouping.canBeNBTGrouped(littleTile)) continue;
                    if (groupNBT == null) {
                        groupNBT = grouping.startNBTGrouping();
                    }
                    grouping.groupNBTTile(groupNBT, littleTile);
                    iterator2.remove();
                }
                if (groupNBT == null) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    grouping.saveTile(nbt);
                    list.func_74742_a((NBTBase)nbt);
                    continue;
                }
                list.func_74742_a(groupNBT);
            }
        }
        return list;
    }

    public static List<LittleTile> readTiles(NBTTagList list, TileEntityLittleTiles te) {
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74764_b("boxes")) {
                LittleTile create = LittleTileRegistry.getTypeFromNBT(nbt).createTile();
                if (create == null) continue;
                List<NBTTagCompound> nbts = create.extractNBTFromGroup(nbt);
                for (int j = 0; j < nbts.size(); ++j) {
                    LittleTile tile = LittleTileRegistry.loadTile(te, te.func_145831_w(), nbts.get(j));
                    if (tile == null) continue;
                    tiles.add(tile);
                }
                continue;
            }
            LittleTile tile = LittleTileRegistry.loadTile(te, te.func_145831_w(), nbt);
            if (tile == null) continue;
            tiles.add(tile);
        }
        return tiles;
    }

    public static NBTTagList writePreviews(LittlePreviews previews) {
        HashMapList groups = new HashMapList();
        for (LittlePreview preview : previews) {
            groups.add((Object)preview.getTypeIdToSave(), (Object)preview);
        }
        NBTTagList list = new NBTTagList();
        for (ArrayList classList : groups.values()) {
            while (classList.size() > 0) {
                LittlePreview grouping = (LittlePreview)classList.remove(0);
                NBTTagCompound groupNBT = null;
                Iterator iterator2 = classList.iterator();
                while (iterator2.hasNext()) {
                    LittlePreview preview = (LittlePreview)iterator2.next();
                    if (!grouping.canBeNBTGrouped(preview)) continue;
                    if (groupNBT == null) {
                        groupNBT = grouping.startNBTGrouping();
                    }
                    grouping.groupNBTTile(groupNBT, preview);
                    iterator2.remove();
                }
                if (groupNBT == null) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    grouping.writeToNBT(nbt);
                    list.func_74742_a((NBTBase)nbt);
                    continue;
                }
                list.func_74742_a(groupNBT);
            }
        }
        return list;
    }

    public static void registerPreviewCompressionHandler(String id, PreviewCompressionHandler handler) {
        if (id.equals("")) {
            defaultHandler = handler;
        }
        handlers.put(id, handler);
    }

    public static LittlePreviews readPreviews(LittlePreviews previews, NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74764_b("boxes")) {
                PreviewCompressionHandler handler = handlers.get(nbt.func_74779_i("tID"));
                if (handler == null) {
                    handler = defaultHandler;
                }
                List<NBTTagCompound> nbts = handler.extractNBTFromGroup(nbt);
                for (int j = 0; j < nbts.size(); ++j) {
                    LittlePreview preview = LittleTileRegistry.loadPreview(nbts.get(j));
                    if (preview == null) continue;
                    previews.addWithoutCheckingPreview(preview);
                }
                continue;
            }
            LittlePreview preview = LittleTileRegistry.loadPreview(nbt);
            if (preview == null) continue;
            previews.addWithoutCheckingPreview(preview);
        }
        return previews;
    }

    public static LittlePreviews readPreviews(LittleGridContext context, NBTTagList list) {
        return LittleNBTCompressionTools.readPreviews(new LittlePreviews(context), list);
    }

    static {
        LittleNBTCompressionTools.registerPreviewCompressionHandler("", ordinaryPreviewHandler);
    }

    public static abstract class PreviewCompressionHandler {
        public abstract List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound var1);
    }
}

