/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.net;

import com.zeitheron.solarflux.SolarFlux;
import com.zeitheron.solarflux.api.SolarFluxAPI;
import com.zeitheron.solarflux.api.SolarInfo;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkSF {
    public static final NetworkSF INSTANCE = null;
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("solarflux");

    public NetworkSF() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void client(FMLNetworkEvent.ClientCustomPacketEvent e) {
        PacketBuffer buf = new PacketBuffer(e.getPacket().payload());
        try {
            NBTTagCompound nbt = buf.func_150793_b();
            switch (nbt.func_74762_e("Action")) {
                case 1: {
                    SolarInfo si = (SolarInfo)SolarFluxAPI.SOLAR_PANELS.getValue(new ResourceLocation(nbt.func_74779_i("SolarInfo")));
                    if (si == null) break;
                    si.connectTextures = nbt.func_74767_n("CT");
                    si.maxTransfer = nbt.func_74762_e("MT");
                    si.maxCapacity = nbt.func_74763_f("MC");
                    si.maxGeneration = nbt.func_74763_f("MG");
                    break;
                }
                case 2: {
                    SolarFlux.proxy.updateWindow(nbt.func_74762_e("id"), nbt.func_74762_e("k"), nbt.func_74763_f("v"));
                    break;
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        buf.release();
    }

    @SubscribeEvent
    public void server(FMLNetworkEvent.ServerCustomPacketEvent e) {
        PacketBuffer buf = new PacketBuffer(e.getPacket().payload());
        try {
            NBTTagCompound nbt = buf.func_150793_b();
            switch (nbt.func_74762_e("Action")) {
                case 1: {
                    INetHandlerPlayServer inet = (INetHandlerPlayServer)e.getHandler();
                    if (!(inet instanceof NetHandlerPlayServer)) break;
                    NetHandlerPlayServer net = (NetHandlerPlayServer)inet;
                    EntityPlayerMP sender = net.field_147369_b;
                    SolarFluxAPI.SOLAR_PANELS.getValuesCollection().forEach(si -> this.send(sender, (SolarInfo)si));
                    SolarFlux.LOG.info("Sent " + SolarFluxAPI.SOLAR_PANELS.getValuesCollection().size() + " Panel Info Packets to " + sender);
                    break;
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        buf.release();
    }

    public void send(EntityPlayerMP mp, SolarInfo si) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Action", 1);
        tag.func_74778_a("SolarInfo", si.getRegistryName().toString());
        tag.func_74757_a("CT", si.connectTextures);
        tag.func_74768_a("MT", si.maxTransfer);
        tag.func_74772_a("MC", si.maxCapacity);
        tag.func_74772_a("MG", si.maxGeneration);
        this.channel.sendTo(new FMLProxyPacket(new PacketBuffer(Unpooled.buffer()).func_150786_a(tag), "solarflux"), mp);
    }

    public void sendWindowProperty(EntityPlayerMP player, Container ctr, int var, long val) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Action", 2);
        tag.func_74768_a("id", ctr.field_75152_c);
        tag.func_74768_a("k", var);
        tag.func_74772_a("v", val);
        this.channel.sendTo(new FMLProxyPacket(new PacketBuffer(Unpooled.buffer()).func_150786_a(tag), "solarflux"), player);
    }

    @SideOnly(value=Side.CLIENT)
    public void request() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Action", 1);
        SolarFlux.LOG.info("Requesting solar configurations from server...");
        this.channel.sendToServer(new FMLProxyPacket(new PacketBuffer(Unpooled.buffer()).func_150786_a(tag), "solarflux"));
    }
}

