/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemBiomeChanger;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class SatelliteBiomeChanger
extends SatelliteBase {
    private Biome biomeId;
    private int radius = 4;
    private List<HashedBlockPosition> toChangeList = new LinkedList<HashedBlockPosition>();
    private Set<Byte> discoveredBiomes = new HashSet<Byte>();
    private static int MAX_SIZE = 1024;

    public void setBiome(Biome biomeId) {
        this.biomeId = biomeId;
    }

    public Biome getBiome() {
        return this.biomeId;
    }

    public Set<Byte> discoveredBiomes() {
        return this.discoveredBiomes;
    }

    public void addBiome(Biome biome) {
        byte byteBiome = (byte)Biome.func_185362_a((Biome)biome);
        if (!AdvancedRocketryBiomes.instance.getBlackListedBiomes().contains(byteBiome)) {
            this.discoveredBiomes.add(byteBiome);
        }
    }

    @Override
    public String getInfo(World world) {
        return "Ready";
    }

    @Override
    public String getName() {
        return "Biome Changer";
    }

    @Override
    @Nonnull
    public ItemStack getControllerItemStack(@Nonnull ItemStack satIdChip, SatelliteProperties properties) {
        ItemBiomeChanger idChipItem = (ItemBiomeChanger)satIdChip.func_77973_b();
        idChipItem.setSatellite(satIdChip, properties);
        return satIdChip;
    }

    @Override
    public boolean isAcceptableControllerItemStack(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBiomeChanger;
    }

    @Override
    public void tickEntity() {
        WorldServer world = DimensionManager.getWorld((int)this.getDimensionId());
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                if (world.func_82737_E() % 1L != 0L || this.toChangeList.isEmpty()) continue;
                if (this.battery.extractEnergy(120, false) != 120) break;
                HashedBlockPosition pos = this.toChangeList.remove(world.field_73012_v.nextInt(this.toChangeList.size()));
                BiomeHandler.changeBiome((World)world, this.biomeId, pos.getBlockPos());
            }
        }
        super.tickEntity();
    }

    public void addBlockToList(HashedBlockPosition pos) {
        if (this.toChangeList.size() < MAX_SIZE) {
            this.toChangeList.add(pos);
        }
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        HashSet set = new HashSet();
        this.radius = 16;
        MAX_SIZE = 1024;
        for (int xx = -this.radius + pos.func_177958_n(); xx < this.radius + pos.func_177958_n(); ++xx) {
            for (int zz = -this.radius + pos.func_177952_p(); zz < this.radius + pos.func_177952_p(); ++zz) {
                this.addBlockToList(new HashedBlockPosition(xx, 0, zz));
            }
        }
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    public IUniversalEnergy getBattery() {
        return this.battery;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        int i;
        super.writeToNBT(nbt);
        nbt.func_74768_a("biomeId", Biome.func_185362_a((Biome)this.biomeId));
        int[] array = new int[this.toChangeList.size() * 3];
        Iterator<HashedBlockPosition> itr = this.toChangeList.iterator();
        for (i = 0; i < this.toChangeList.size(); i += 3) {
            HashedBlockPosition pos = itr.next();
            array[i] = pos.x;
            array[i + 1] = pos.y;
            array[i + 2] = pos.z;
        }
        nbt.func_74782_a("posList", (NBTBase)new NBTTagIntArray(array));
        array = new int[this.discoveredBiomes.size()];
        i = 0;
        for (byte biome : this.discoveredBiomes) {
            array[i] = biome;
            ++i;
        }
        nbt.func_74782_a("biomeList", (NBTBase)new NBTTagIntArray(array));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.biomeId = Biome.func_150568_d((int)nbt.func_74762_e("biomeId"));
        int[] array = nbt.func_74759_k("posList");
        this.toChangeList.clear();
        for (int i = 0; i < array.length; i += 3) {
            this.toChangeList.add(new HashedBlockPosition(array[i], array[i + 1], array[i + 2]));
        }
        array = nbt.func_74759_k("biomeList");
        this.discoveredBiomes.clear();
        for (int value : array) {
            this.discoveredBiomes.add((byte)value);
        }
    }
}

