/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.satellite;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.inventory.modules.ModuleSatellite;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.satellite.SatelliteData;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileSatelliteTerminal
extends TileInventoriedRFConsumer
implements INetworkMachine,
IModularInventory,
IButtonInventory,
IDataInventory {
    private SatelliteBase satellite;
    private ModuleText moduleText;
    private DataStorage data = new DataStorage();

    public TileSatelliteTerminal() {
        super(10000, 2);
        this.data.setMaxData(1000);
    }

    @Nonnull
    public int[] func_180463_a(@Nullable EnumFacing side) {
        return new int[0];
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockSatelliteControlCenter.func_149732_F();
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean canPerformFunction() {
        return this.field_145850_b.func_82737_E() % 16L == 0L && this.getSatelliteFromSlot(0) != null;
    }

    public int getPowerPerOperation() {
        return 1;
    }

    public void performFunction() {
        if (this.field_145850_b.field_72995_K) {
            this.updateInventoryInfo();
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            this.storeData(0);
        } else if (id == 100) {
            if (this.satellite != null && PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(this.satellite.getDimensionId(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
                this.satellite.performAction(player, this.field_145850_b, this.field_174879_c);
            }
        } else if (id == 101) {
            this.onInventoryButtonPressed(id - 100);
        }
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.satellite = this.getSatelliteFromSlot(0);
        this.updateInventoryInfo();
    }

    public void updateInventoryInfo() {
        if (this.moduleText != null) {
            if (this.satellite != null) {
                if (this.getUniversalEnergyStored() < this.getPowerPerOperation()) {
                    this.moduleText.setText(LibVulpes.proxy.getLocalizedString("msg.notenoughpower"));
                } else if (!PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(this.satellite.getDimensionId(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
                    this.moduleText.setText(this.satellite.getName() + "\n\n" + LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.toofar"));
                } else {
                    this.moduleText.setText(this.satellite.getName() + "\n\n" + LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.info") + "\n" + this.satellite.getInfo(this.field_145850_b));
                }
            } else {
                this.moduleText.setText(LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"));
            }
        }
    }

    public SatelliteBase getSatelliteFromSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            return ItemSatelliteIdentificationChip.getSatellite(stack);
        }
        return null;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.energy));
        modules.add((ModuleBase)new ModuleButton(116, 70, 0, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.connect"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        modules.add((ModuleBase)new ModuleButton(173, 3, 1, "", (IButtonInventory)this, TextureResources.buttonKill, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.destroysat"), 24, 24));
        modules.add(new ModuleData(28, 20, 1, this, this.data));
        ModuleSatellite moduleSatellite = new ModuleSatellite(152, 10, this, 0);
        moduleSatellite.setSatellite(this.satellite);
        modules.add((ModuleBase)moduleSatellite);
        this.moduleText = new ModuleText(60, 20, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"), 0x404040);
        modules.add((ModuleBase)this.moduleText);
        this.updateInventoryInfo();
        return modules;
    }

    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack;
        if (buttonId == 0) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        } else if (buttonId == 1 && !(stack = this.func_70301_a(0)).func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            ItemSatelliteIdentificationChip idchip = (ItemSatelliteIdentificationChip)stack.func_77973_b();
            SatelliteBase satellite = ItemSatelliteIdentificationChip.getSatellite(stack);
            if (satellite != null) {
                DimensionManager.getInstance().getDimensionProperties(satellite.getDimensionId()).removeSatellite(satellite.getId());
            }
            idchip.erase(stack);
            this.func_70299_a(0, stack);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound data = new NBTTagCompound();
        this.data.writeToNBT(data);
        nbt.func_74782_a("data", (NBTBase)data);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound data = nbt.func_74775_l("data");
        this.data.readFromNBT(data);
    }

    @Override
    public void loadData(int id) {
    }

    @Override
    public void storeData(int id) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = this.func_70301_a(1);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemData && stack.func_190916_E() == 1) {
                ItemData dataItem = (ItemData)stack.func_77973_b();
                this.data.removeData(dataItem.addData(stack, this.data.getData(), this.data.getDataType()), true);
            }
        } else {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        SatelliteBase satellite = this.getSatelliteFromSlot(0);
        if (satellite instanceof SatelliteData && PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(satellite.getDimensionId(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
            satellite.performAction(null, this.field_145850_b, this.field_174879_c);
        }
        if (type == this.data.getDataType() || this.data.getDataType() == DataStorage.DataType.UNDEFINED) {
            return this.data.removeData(maxAmount, commit);
        }
        return 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        return this.data.addData(maxAmount, type, commit);
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }
}

