/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentPosition;
import modulardiversity.jei.ingredients.Position;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RequirementPosition
extends RequirementEnvironmental<Position, ResourceToken> {
    public float xMin;
    public float xMax;
    public float yMin;
    public float yMax;
    public float zMin;
    public float zMax;
    public float distanceMin;
    public float distanceMax;

    public RequirementPosition(MachineComponent.IOType actionType, float xMin, float xMax, float yMin, float yMax, float zMin, float zMax, float distanceMin, float distanceMax) {
        super(ComponentType.Registry.getComponent((String)"position"), actionType);
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.distanceMin = distanceMin;
        this.distanceMax = distanceMax;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.position";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken();
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        boolean matched = false;
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            float dz;
            float dy;
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            float dx = this.getDistance(pos.func_177958_n(), this.xMin, this.xMax);
            double dist = Math.sqrt(dx * dx + (dy = this.getDistance(pos.func_177956_o(), this.yMin, this.yMax)) * dy + (dz = this.getDistance(pos.func_177952_p(), this.zMin, this.zMax)) * dz);
            matched = dist >= (double)this.distanceMin && dist <= (double)this.distanceMax;
            token.setMatched(matched);
        }
        return matched;
    }

    private float getDistance(float coord, float min, float max) {
        if (coord < min) {
            return min - coord;
        }
        if (coord > max) {
            return coord - max;
        }
        return 0.0f;
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        return true;
    }

    public ComponentRequirement<Position> deepCopy() {
        return new RequirementPosition(this.getActionType(), this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.distanceMin, this.distanceMax);
    }

    public ComponentRequirement<Position> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementPosition(this.getActionType(), this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.distanceMin, this.distanceMax);
    }

    public ComponentRequirement.JEIComponent<Position> provideJEIComponent() {
        return new JEIComponentPosition(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        boolean matched;

        public void setMatched(boolean matched) {
            this.matched = matched;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
        }

        @Override
        public boolean isEmpty() {
            return this.matched;
        }
    }
}

