/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipePrimer;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import modulardiversity.components.requirements.RequirementAura;
import modulardiversity.components.requirements.RequirementBiome;
import modulardiversity.components.requirements.RequirementDaylight;
import modulardiversity.components.requirements.RequirementDimension;
import modulardiversity.components.requirements.RequirementEmber;
import modulardiversity.components.requirements.RequirementEmberWorld;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.components.requirements.RequirementHotAir;
import modulardiversity.components.requirements.RequirementLaser;
import modulardiversity.components.requirements.RequirementMana;
import modulardiversity.components.requirements.RequirementMechanical;
import modulardiversity.components.requirements.RequirementMekHeat;
import modulardiversity.components.requirements.RequirementMekLaser;
import modulardiversity.components.requirements.RequirementMineral;
import modulardiversity.components.requirements.RequirementMysticalMechanics;
import modulardiversity.components.requirements.RequirementPosition;
import modulardiversity.components.requirements.RequirementReservoir;
import modulardiversity.components.requirements.RequirementWeather;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenExpansion(value="mods.modularmachinery.RecipePrimer")
public class PrimerExtension {
    @ZenMethod
    public static RecipePrimer setPerTick(RecipePrimer primer, boolean perTick) {
        PrimerExtension.runOnLastRequirement(primer, RequirementEnvironmental.class, "setPerTick", requirement -> requirement.setPerTick(perTick));
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addAuraInput(RecipePrimer primer, float visAdded, float fluxAdded) {
        PrimerExtension.requireAura(primer, MachineComponent.IOType.INPUT, visAdded, fluxAdded);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addAuraOutput(RecipePrimer primer, float visAdded, float fluxAdded) {
        PrimerExtension.requireAura(primer, MachineComponent.IOType.OUTPUT, visAdded, fluxAdded);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addVisRequirement(RecipePrimer primer, float visMin, float visMax) {
        PrimerExtension.runOnLastRequirement(primer, RequirementAura.class, "addVisRequirement", requirement -> {
            requirement.visMin = visMin;
            requirement.visMax = visMax;
        });
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addFluxRequirement(RecipePrimer primer, float fluxMin, float fluxMax) {
        PrimerExtension.runOnLastRequirement(primer, RequirementAura.class, "addFluxRequirement", requirement -> {
            requirement.fluxMin = fluxMin;
            requirement.fluxMax = fluxMax;
        });
        return primer;
    }

    private static void requireAura(RecipePrimer primer, MachineComponent.IOType io, float vis, float flux) {
        primer.appendComponent((ComponentRequirement)new RequirementAura(io, 0.0f, Float.POSITIVE_INFINITY, 0.0f, Float.POSITIVE_INFINITY, vis, flux));
    }

    @ZenMethod
    public static RecipePrimer addMineralInput(RecipePrimer primer, String name, int added) {
        PrimerExtension.requireMineral(primer, MachineComponent.IOType.INPUT, name, added);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addMineralOutput(RecipePrimer primer, String name, int added) {
        PrimerExtension.requireMineral(primer, MachineComponent.IOType.OUTPUT, name, added);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addOreRequirement(RecipePrimer primer, int min, int max) {
        PrimerExtension.runOnLastRequirement(primer, RequirementMineral.class, "addOreRequirement", requirement -> {
            requirement.oreMin = min;
            requirement.oreMax = max;
        });
        return primer;
    }

    private static void requireMineral(RecipePrimer primer, MachineComponent.IOType io, String name, int added) {
        primer.appendComponent((ComponentRequirement)new RequirementMineral(io, name, 0, Integer.MAX_VALUE, added));
    }

    @ZenMethod
    public static RecipePrimer addReservoirInput(RecipePrimer primer, String name, int added) {
        PrimerExtension.requireReservoir(primer, MachineComponent.IOType.INPUT, name, added);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addReservoirOutput(RecipePrimer primer, String name, int added) {
        PrimerExtension.requireReservoir(primer, MachineComponent.IOType.OUTPUT, name, added);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addReservoirFluidRequirement(RecipePrimer primer, int min, int max) {
        PrimerExtension.runOnLastRequirement(primer, RequirementReservoir.class, "addReservoirFluidRequirement", requirement -> {
            requirement.fluidMin = min;
            requirement.fluidMax = max;
        });
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addReservoirResidualRequirement(RecipePrimer primer, int min, int max) {
        PrimerExtension.runOnLastRequirement(primer, RequirementReservoir.class, "addReservoirResidualRequirement", requirement -> {
            requirement.residualMin = min;
            requirement.residualMax = max;
        });
        return primer;
    }

    private static void requireReservoir(RecipePrimer primer, MachineComponent.IOType io, String name, int added) {
        primer.appendComponent((ComponentRequirement)new RequirementReservoir(io, name, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, added));
    }

    @ZenMethod
    public static RecipePrimer addMantleRequirement(RecipePrimer primer, float emberMin, float emberMax, float stabilityMin, float stabilityMax) {
        primer.appendComponent((ComponentRequirement)new RequirementEmberWorld(MachineComponent.IOType.INPUT, emberMin, emberMax, stabilityMin, stabilityMax));
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addManaInput(RecipePrimer primer, int mana) {
        PrimerExtension.requireMana(primer, MachineComponent.IOType.INPUT, mana);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addManaOutput(RecipePrimer primer, int mana) {
        PrimerExtension.requireMana(primer, MachineComponent.IOType.OUTPUT, mana);
        return primer;
    }

    private static void requireMana(RecipePrimer primer, MachineComponent.IOType io, int mana) {
        primer.appendComponent((ComponentRequirement)new RequirementMana(io, mana));
    }

    @ZenMethod
    public static RecipePrimer addMechanicalInput(RecipePrimer primer, int power) {
        PrimerExtension.requireMechanical(primer, MachineComponent.IOType.INPUT, power, false);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addMechanicalCrankInput(RecipePrimer primer, int power) {
        PrimerExtension.requireMechanical(primer, MachineComponent.IOType.INPUT, power, true);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addMechanicalOutput(RecipePrimer primer, int power) {
        PrimerExtension.requireMechanical(primer, MachineComponent.IOType.OUTPUT, power, false);
        return primer;
    }

    private static void requireMechanical(RecipePrimer primer, MachineComponent.IOType io, int power, boolean crankAllowed) {
        primer.appendComponent((ComponentRequirement)new RequirementMechanical(io, power, crankAllowed));
    }

    @ZenMethod
    public static RecipePrimer addEmberInput(RecipePrimer primer, double ember) {
        PrimerExtension.requireEmber(primer, MachineComponent.IOType.INPUT, ember);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addEmberOutput(RecipePrimer primer, double ember) {
        PrimerExtension.requireEmber(primer, MachineComponent.IOType.OUTPUT, ember);
        return primer;
    }

    private static void requireEmber(RecipePrimer primer, MachineComponent.IOType io, double ember) {
        primer.appendComponent((ComponentRequirement)new RequirementEmber(io, ember));
    }

    @ZenMethod
    public static RecipePrimer addLaserInput(RecipePrimer primer, long mMJ) {
        PrimerExtension.requireLaser(primer, MachineComponent.IOType.INPUT, mMJ);
        return primer;
    }

    private static void requireLaser(RecipePrimer primer, MachineComponent.IOType io, long mMJ) {
        primer.appendComponent((ComponentRequirement)new RequirementLaser(io, mMJ));
    }

    @ZenMethod
    public static RecipePrimer addMekanismLaserInput(RecipePrimer primer, double power) {
        PrimerExtension.requireMekanismLaser(primer, MachineComponent.IOType.INPUT, power);
        return primer;
    }

    private static void requireMekanismLaser(RecipePrimer primer, MachineComponent.IOType io, double power) {
        primer.appendComponent((ComponentRequirement)new RequirementMekLaser(io, power));
    }

    @ZenMethod
    public static RecipePrimer addHotAirInput(RecipePrimer primer, int temperature, int temperatureMin, int temperatureMax) {
        PrimerExtension.requireHotAir(primer, MachineComponent.IOType.INPUT, temperature, temperatureMin, temperatureMax);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addHotAirOutput(RecipePrimer primer, int temperature, int temperatureMin, int temperatureMax) {
        PrimerExtension.requireHotAir(primer, MachineComponent.IOType.OUTPUT, temperature, temperatureMin, temperatureMax);
        return primer;
    }

    private static void requireHotAir(RecipePrimer primer, MachineComponent.IOType io, int temperature, int temperatureMin, int temperatureMax) {
        primer.appendComponent((ComponentRequirement)new RequirementHotAir(io, temperature, temperatureMin, temperatureMax));
    }

    @ZenMethod
    public static RecipePrimer addMekanismHeatInput(RecipePrimer primer, float temperature, float temperatureMin, double temperatureMax) {
        PrimerExtension.requireMekanismHeat(primer, MachineComponent.IOType.INPUT, temperature, temperatureMin, temperatureMax);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addMekanismHeatOutput(RecipePrimer primer, float temperature, float temperatureMin, double temperatureMax) {
        PrimerExtension.requireMekanismHeat(primer, MachineComponent.IOType.OUTPUT, temperature, temperatureMin, temperatureMax);
        return primer;
    }

    private static void requireMekanismHeat(RecipePrimer primer, MachineComponent.IOType io, double temperature, double temperatureMin, double temperatureMax) {
        primer.appendComponent((ComponentRequirement)new RequirementMekHeat(io, temperature, temperatureMin, temperatureMax));
    }

    @ZenMethod
    public static RecipePrimer addMysticalMechanicsInput(RecipePrimer primer, double min, double max) {
        primer.appendComponent((ComponentRequirement)new RequirementMysticalMechanics(MachineComponent.IOType.INPUT, min, max));
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addMysticalMechanicsOutput(RecipePrimer primer, double level) {
        primer.appendComponent((ComponentRequirement)new RequirementMysticalMechanics(MachineComponent.IOType.OUTPUT, level));
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addLocalTimeRequirement(RecipePrimer primer, long mod, long min, long max) {
        PrimerExtension.requireTime(primer, MachineComponent.IOType.INPUT, true, mod, min, max);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addGlobalTimeRequirement(RecipePrimer primer, long mod, long min, long max) {
        PrimerExtension.requireTime(primer, MachineComponent.IOType.INPUT, false, mod, min, max);
        return primer;
    }

    private static void requireTime(RecipePrimer primer, MachineComponent.IOType io, boolean local, long mod, long min, long max) {
        primer.appendComponent((ComponentRequirement)new RequirementDaylight(io, min, max, mod, local));
    }

    @ZenMethod
    public static RecipePrimer addClearWeatherRequirement(RecipePrimer primer) {
        PrimerExtension.requireWeather(primer, MachineComponent.IOType.INPUT, RequirementWeather.Type.CLEAR);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addRainWeatherRequirement(RecipePrimer primer) {
        PrimerExtension.requireWeather(primer, MachineComponent.IOType.INPUT, RequirementWeather.Type.RAIN);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addSnowWeatherRequirement(RecipePrimer primer) {
        PrimerExtension.requireWeather(primer, MachineComponent.IOType.INPUT, RequirementWeather.Type.SNOW);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addStormWeatherRequirement(RecipePrimer primer) {
        PrimerExtension.requireWeather(primer, MachineComponent.IOType.INPUT, RequirementWeather.Type.STORM);
        return primer;
    }

    private static void requireWeather(RecipePrimer primer, MachineComponent.IOType io, RequirementWeather.Type type) {
        primer.appendComponent((ComponentRequirement)new RequirementWeather(io, type));
    }

    @ZenMethod
    public static RecipePrimer addBiomeRequirement(RecipePrimer primer, int[] biomes) {
        PrimerExtension.requireBiome(primer, MachineComponent.IOType.INPUT, biomes);
        return primer;
    }

    private static void requireBiome(RecipePrimer primer, MachineComponent.IOType io, int[] biomes) {
        primer.appendComponent((ComponentRequirement)new RequirementBiome(io, biomes));
    }

    @ZenMethod
    public static RecipePrimer addDimensionRequirement(RecipePrimer primer, int[] dimensions) {
        PrimerExtension.requireDimension(primer, MachineComponent.IOType.INPUT, dimensions);
        return primer;
    }

    private static void requireDimension(RecipePrimer primer, MachineComponent.IOType io, int[] dimensions) {
        primer.appendComponent((ComponentRequirement)new RequirementDimension(io, dimensions));
    }

    @ZenMethod
    public static RecipePrimer addPositionRequirement(RecipePrimer primer, float x, float y, float z) {
        PrimerExtension.requirePosition(primer, MachineComponent.IOType.INPUT, x, x, y, y, z, z);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addAreaRequirement(RecipePrimer primer, float xMin, float xMax, float yMin, float yMax, float zMin, float zMax) {
        PrimerExtension.requirePosition(primer, MachineComponent.IOType.INPUT, xMin, xMax, yMin, yMax, zMin, zMax);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer addYRequirement(RecipePrimer primer, float yMin, float yMax) {
        PrimerExtension.requirePosition(primer, MachineComponent.IOType.INPUT, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, yMin, yMax, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
        return primer;
    }

    @ZenMethod
    public static RecipePrimer setDistance(RecipePrimer primer, float distanceMin, float distanceMax) {
        PrimerExtension.runOnLastRequirement(primer, RequirementPosition.class, "setDistance", requirement -> {
            requirement.distanceMin = distanceMin;
            requirement.distanceMax = distanceMax;
        });
        return primer;
    }

    private static void requirePosition(RecipePrimer primer, MachineComponent.IOType io, float xMin, float xMax, float yMin, float yMax, float zMin, float zMax) {
        primer.appendComponent((ComponentRequirement)new RequirementPosition(io, xMin, xMax, yMin, yMax, zMin, zMax, 0.0f, 0.0f));
    }

    private static <T extends ComponentRequirement> void runOnLastRequirement(RecipePrimer primer, Class<T> requiredClass, String method, Consumer<T> consumer) {
        ComponentRequirement last = PrimerExtension.getLastRequirement(primer);
        if (requiredClass.isInstance(last)) {
            consumer.accept(last);
        } else {
            CraftTweakerAPI.logError((String)("Wrong component to call " + method + ". (Expected: " + requiredClass + ", Got: " + last.getClass() + ")"));
        }
    }

    private static ComponentRequirement getLastRequirement(RecipePrimer primer) {
        List requirementList = primer.getComponents();
        if (requirementList instanceof LinkedList) {
            return (ComponentRequirement)((LinkedList)requirementList).getLast();
        }
        return (ComponentRequirement)requirementList.get(requirementList.size() - 1);
    }
}

