/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.info;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IConstantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IDependantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.info.DependencyVisitorRouting;
import java.util.HashSet;
import java.util.Set;

public class DependencyVisitorCollector
extends DependencyVisitorRouting {
    private boolean allConstant = true;
    private boolean needsUnkown = false;
    private final Set<IExpressionNode> mutableNodes;

    private DependencyVisitorCollector(Set<IExpressionNode> mutableNodes) {
        this.mutableNodes = mutableNodes;
    }

    public static DependencyVisitorCollector createConstantSearch() {
        return new DependencyVisitorCollector(null);
    }

    public static DependencyVisitorCollector createFullSearch() {
        return new DependencyVisitorCollector(new HashSet<IExpressionNode>());
    }

    public static boolean testIsConstant(IDependantNode ... node) {
        DependencyVisitorCollector search = DependencyVisitorCollector.createConstantSearch();
        search.dependOn(node);
        return search.areAllConstant();
    }

    public static Set<IExpressionNode> searchMutableNodes(IDependantNode ... nodes) {
        DependencyVisitorCollector search = DependencyVisitorCollector.createFullSearch();
        search.dependOn(nodes);
        return search.getMutableNodes();
    }

    @Override
    protected boolean visit(IExpressionNode node) {
        if (node instanceof IConstantNode) {
            return true;
        }
        this.allConstant = false;
        if (this.mutableNodes == null) {
            return false;
        }
        this.mutableNodes.add(node);
        return true;
    }

    @Override
    public void dependOnUnknown() {
        this.needsUnkown = true;
    }

    public boolean areAllConstant() {
        return this.allConstant;
    }

    public boolean needsUnkown() {
        return this.needsUnkown;
    }

    public Set<IExpressionNode> getMutableNodes() {
        if (this.mutableNodes == null) {
            throw new IllegalStateException("Attempted to get a list of all mutable nodes when this object was constructed from #createConstantSearch()!");
        }
        return this.mutableNodes;
    }
}

